<?php
require_once 'db.php';
check_login();

if ($_SESSION['role'] === 'admin' && isset($_GET['debtor_id'])) {
    $did = $_GET['debtor_id'];
} else {
    $did = $_SESSION['debtor_id'];
}
if (!$did) exit('債務者IDが特定できません');

$st_d = $pdo->prepare("SELECT name, pay_day, initial_balance FROM debtors WHERE debtor_id = ?");
$st_d->execute([$did]);
$debtor = $st_d->fetch();
if (!$debtor) exit('債務者情報が見つかりません');

$target_pay_day = $debtor['pay_day'] ?? 25;
$initial_balance = $debtor['initial_balance'] ?? 0;
$month_param = $_GET['month'] ?? date('Y-m');
$view_mode = $_GET['view'] ?? 'summary'; 

function get_start_date($pdo, $did, $ym, $def_day) {
    list($y, $m) = explode('-', $ym);
    $salary_pattern = '%給与%';
    $st1 = $pdo->prepare("SELECT MIN(t.date) FROM transactions t JOIN categories c ON t.category_id = c.category_id WHERE t.debtor_id = ? AND c.category_name LIKE ? AND t.user_code = ? AND t.date LIKE ?");
    $st1->execute([$did, $salary_pattern, $did . '1', $ym . '%']);
    $d1 = $st1->fetchColumn();
    if ($d1) return $d1;
    $st2 = $pdo->prepare("SELECT MIN(t.date) FROM transactions t JOIN categories c ON t.category_id = c.category_id WHERE t.debtor_id = ? AND c.category_name LIKE ? AND t.user_code = ? AND t.date LIKE ?");
    $st2->execute([$did, $salary_pattern, $did . '2', $ym . '%']);
    $d2 = $st2->fetchColumn();
    if ($d2) return $d2;
    return date('Y-m-d', mktime(0, 0, 0, (int)$m, (int)$def_day, (int)$y));
}

$start_date = get_start_date($pdo, $did, $month_param, $target_pay_day);
$next_month_param = date('Y-m', strtotime($month_param . '-01 +1 month'));
$next_start = get_start_date($pdo, $did, $next_month_param, $target_pay_day);
$end_date = date('Y-m-d', strtotime($next_start . " -1 day"));

$st_prev = $pdo->prepare("SELECT SUM(CASE WHEN c.type='income' THEN t.amount ELSE -t.amount END) FROM transactions t JOIN categories c ON t.category_id=c.category_id WHERE t.debtor_id=? AND t.date < ?");
$st_prev->execute([$did, $start_date]);
$carry_forward = $initial_balance + ($st_prev->fetchColumn() ?: 0);

// 並べ替えに必要な sort_order と category_id も取得するように変更
$st = $pdo->prepare("SELECT t.*, c.category_name, c.type, c.is_combined, c.sort_order, c.category_id, u.user_name 
                     FROM transactions t 
                     JOIN categories c ON t.category_id=c.category_id 
                     LEFT JOIN users u ON t.user_code=u.user_code 
                     WHERE t.debtor_id=? AND t.date BETWEEN ? AND ? 
                     ORDER BY t.date ASC, t.id ASC");
$st->execute([$did, $start_date, $end_date]);
$transactions = $st->fetchAll();

$summary_data = ['income' => [], 'expense' => []];
$total_income = 0; $total_expense = 0;

foreach ($transactions as $t) {
    $disp_name = $t['category_name'];
    if ($t['is_combined'] == 0) {
        $lastDigit = substr($t['user_code'] ?? '', -1);
        $disp_name .= ($lastDigit === '1') ? '（本人）' : '（配偶者）';
    }

    // 並べ替え用のキーを作成（sort_order_categoryID_名前）
    // sprintfで桁を揃えることで、文字列比較でも正しく数値順になるようにします
    $sort_key = sprintf('%05d_%05d_%s', $t['sort_order'], $t['category_id'], $disp_name);
    
    $type = $t['type'];
    if (!isset($summary_data[$type][$sort_key])) {
        $summary_data[$type][$sort_key] = ['name' => $disp_name, 'amount' => 0];
    }
    $summary_data[$type][$sort_key]['amount'] += $t['amount'];

    if ($type === 'income') $total_income += $t['amount']; 
    else $total_expense += $t['amount'];
}

// 収入・支出それぞれのカテゴリをキー（sort_key）で昇順ソート
ksort($summary_data['income']);
ksort($summary_data['expense']);

$back_url = ($_SESSION['role'] === 'admin') ? 'index.php' : 'home.php';
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $view_mode == 'summary' ? '集計表' : '明細表' ?>_<?= $month_param ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { background-color: #f4f7f6; font-family: "Helvetica Neue", Arial, sans-serif; color: #333; margin: 0; padding: 0; overflow-x: hidden; }
        
        .no-print-area { background: #2c3e50; padding: 15px 10px; color: white; width: 100%; position: sticky; top: 0; z-index: 1000; }
        .nav-wrapper { display: flex; flex-direction: column; gap: 12px; align-items: center; max-width: 900px; margin: 0 auto; }
        .month-selector { display: flex; align-items: center; justify-content: center; gap: 8px; width: 100%; }
        .btn-nav { background: rgba(255,255,255,0.15); color: white; border: 1px solid rgba(255,255,255,0.3); border-radius: 8px; padding: 8px; text-decoration: none; font-size: 0.85rem; flex: 1; text-align: center; }
        .current-month-display { font-size: 1.2rem; font-weight: bold; min-width: 90px; text-align: center; }
        .tab-switcher { display: flex; background: rgba(0,0,0,0.2); border-radius: 10px; padding: 3px; width: 100%; }
        .tab-btn { flex: 1; text-align: center; padding: 8px; color: #bdc3c7; text-decoration: none; font-size: 0.9rem; font-weight: bold; border-radius: 8px; }
        .tab-btn.active { background: #3498db; color: white; }
        .btn-back { background: #7f8c8d; color: white; border-radius: 8px; padding: 8px; text-decoration: none; flex: 1; text-align: center; font-size: 0.9rem; width: 100%; }
        .btn-print-action { background: #e74c3c; color: white; border: none; border-radius: 8px; padding: 8px; flex: 2; font-weight: bold; font-size: 0.9rem; width: 100%; }

        .report-container { width: 100%; overflow-x: auto; padding: 20px 10px; -webkit-overflow-scrolling: touch; }
        .report-paper { 
            background: white; 
            padding: 30px 20px 30px 15mm; 
            border-radius: 4px; 
            box-shadow: 0 0 10px rgba(0,0,0,0.05); 
            margin: 0 auto; 
            min-width: 900px; 
            max-width: 1080px; 
        }
        .print-font { font-family: "MS Mincho", "Hiragino Mincho ProN", serif; }
        
        table { width: 100%; border-collapse: collapse; border: 2px solid #000; margin-bottom: 10px; table-layout: fixed; }
        th, td { border: 1px solid #000; padding: 8px 6px; font-size: 0.85rem; word-wrap: break-word; vertical-align: middle; }
        th { background: #f2f2f2 !important; text-align: center; }

        .col-date { width: 60px; text-align: center; }
        .col-cat  { width: 230px; } 
        .col-amt  { width: 110px; } 
        .col-memo { width: auto; } 
        .col-act  { width: 120px; text-align: center; }
        .amt-val { text-align: right; }
        .action-icons { display: flex; justify-content: center; gap: 10px; }

        @media (min-width: 768px) {
            .nav-wrapper { flex-direction: row; }
            .month-selector { width: auto; }
            .tab-switcher { width: 220px; }
            .btn-back, .btn-print-action { width: auto; }
            .btn-nav { width: 80px; flex: none; }
            .report-container { padding: 40px 20px; }
            .report-paper { min-width: auto; }
        }

        @media print { 
            body { background: white !important; }
            .no-print-area, .no-print { display: none !important; } 
            
            .report-container { padding: 0 !important; overflow: visible !important; }
            .report-paper { 
                box-shadow: none !important; 
                padding: 0 0 0 15mm !important; 
                margin: 0 !important; 
                width: 100% !important; 
                max-width: 100% !important; 
                min-width: auto !important; 
            }
            tr { page-break-inside: avoid; }
            thead { display: table-header-group; }
            .col-cat { width: 220px !important; } 
            .col-amt { width: 90px !important; } 
            .row { display: flex !important; flex-wrap: nowrap !important; }
            .col-6 { width: 49.5% !important; flex: 0 0 49.5% !important; }
        }
    </style>
</head>
<body>

<div class="no-print-area">
    <div class="nav-wrapper">
        <div style="display:flex; gap:10px; width:100%; flex-wrap: wrap;">
            <a href="<?= $back_url ?>" class="btn-back" style="flex:1;"><i class="bi bi-chevron-left"></i> 戻る</a>
            <button onclick="window.print()" class="btn-print-action" style="flex:2;"><i class="bi bi-printer"></i> 報告書を印刷</button>
        </div>
        <div class="month-selector">
            <a href="?debtor_id=<?= $did ?>&view=<?= $view_mode ?>&month=<?= date('Y-m', strtotime($month_param.'-01 -1 month')) ?>" class="btn-nav">◀ 前月</a>
            <div class="current-month-display"><?= date('n月', strtotime($month_param.'-01')) ?></div>
            <a href="?debtor_id=<?= $did ?>&view=<?= $view_mode ?>&month=<?= date('Y-m', strtotime($month_param.'-01 +1 month')) ?>" class="btn-nav">次月 ▶</a>
        </div>
        <div class="tab-switcher">
            <a href="?debtor_id=<?= $did ?>&month=<?= $month_param ?>&view=summary" class="tab-btn <?= $view_mode=='summary'?'active':'' ?>">集計表</a>
            <a href="?debtor_id=<?= $did ?>&month=<?= $month_param ?>&view=detail" class="tab-btn <?= $view_mode=='detail'?'active':'' ?>">明細一覧</a>
        </div>
    </div>
</div>

<div class="report-container">
    <div class="report-paper print-font">
        <h3 class="text-center fw-bold mb-4" style="text-decoration: underline; letter-spacing: 3px;">
            <?= $view_mode == 'summary' ? '科目別収支集計表' : '収支明細一覧表' ?>（<?= (int)date('m', strtotime($month_param)) ?>月分）
        </h3>
        
        <div class="d-flex justify-content-between mb-2 fw-bold small">
            <div>氏名： <?= htmlspecialchars($debtor['name']) ?>　様</div>
            <div class="text-end">対象期間： <?= date('Y/m/d', strtotime($start_date)) ?> ～ <?= date('Y/m/d', strtotime($end_date)) ?></div>
        </div>

        <?php if ($view_mode == 'summary'): ?>
            <div class="row g-2">
                <div class="col-6" style="width: 49.5%;">
                    <table>
                        <thead><tr><th colspan="2">収入の部</th></tr></thead>
                        <tbody>
                            <tr class="fw-bold"><td>前月繰越金</td><td class="amt-val" style="width:110px;">¥<?= number_format($carry_forward) ?></td></tr>
                            <?php foreach ($summary_data['income'] as $item): ?>
                                <tr><td><?= htmlspecialchars($item['name']) ?></td><td class="amt-val">¥<?= number_format($item['amount']) ?></td></tr>
                            <?php endforeach; ?>
                            <tr class="fw-bold bg-light"><td>収入合計</td><td class="amt-val">¥<?= number_format($carry_forward + $total_income) ?></td></tr>
                        </tbody>
                    </table>
                </div>
                <div class="col-6" style="width: 49.5%;">
                    <table>
                        <thead><tr><th colspan="2">支出の部</th></tr></thead>
                        <tbody>
                            <?php foreach ($summary_data['expense'] as $item): ?>
                                <tr><td><?= htmlspecialchars($item['name']) ?></td><td class="amt-val" style="width:110px;">¥<?= number_format($item['amount']) ?></td></tr>
                            <?php endforeach; ?>
                            <tr class="fw-bold bg-light"><td>支出合計</td><td class="amt-val">¥<?= number_format($total_expense) ?></td></tr>
                        </tbody>
                    </table>
                </div>
            </div>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th class="col-date">日付</th>
                        <th class="col-cat">科目</th>
                        <th class="col-amt">収入</th>
                        <th class="col-amt">支出</th>
                        <th class="col-memo">備考</th>
                        <th class="no-print col-act">操作</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="fw-bold bg-light">
                        <td class="text-center">-</td>
                        <td>前月繰越</td>
                        <td class="amt-val">¥<?= number_format($carry_forward) ?></td>
                        <td class="amt-val"></td>
                        <td></td>
                        <td class="no-print"></td>
                    </tr>
                    <?php foreach ($transactions as $t): ?>
                    <tr>
                        <td class="text-center"><?= date('m/d', strtotime($t['date'])) ?></td>
                        <td>
                            <?php 
                                $lastDigit = substr($t['user_code'] ?? '', -1);
                                $disp = $t['category_name'] . ($lastDigit === '1' ? '（本人）' : '（配偶者）');
                                echo htmlspecialchars($disp);
                            ?>
                        </td>
                        <td class="amt-val"><?= $t['type']=='income'?'¥'.number_format($t['amount']):'' ?></td>
                        <td class="amt-val"><?= $t['type']=='expense'?'¥'.number_format($t['amount']):'' ?></td>
                        <td style="font-size: 0.8rem;"><?= nl2br(htmlspecialchars($t['memo'])) ?></td>
                        <td class="no-print">
                            <div class="action-icons">
                                <?php if ($t['image_path']): ?>
                                    <a href="<?= htmlspecialchars($t['image_path']) ?>" target="_blank" class="text-primary"><i class="bi bi-image"></i></a>
                                <?php else: ?>
                                    <span style="width:18px;"></span>
                                <?php endif; ?>
                                <a href="edit_transaction.php?id=<?= $t['id'] ?>" class="text-success"><i class="bi bi-pencil-square"></i></a>
                                <a href="delete_transaction.php?id=<?= $t['id'] ?>" class="text-danger" onclick="return confirm('削除しますか？')"><i class="bi bi-trash"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>

        <div class="text-end h6 fw-bold mt-4" style="page-break-inside: avoid;">
            次月繰越額： <span style="border-bottom: 3px double #000; padding: 0 5px; font-size: 1.3rem;">¥<?= number_format($carry_forward + $total_income - $total_expense) ?></span>
        </div>
    </div>
</div>

</body>
</html>