<?php
require_once 'db.php';
check_login();

// 弁護士（admin）のみ実行可能
if ($_SESSION['role'] !== 'admin') { exit('権限がありません'); }

try {
    // テーブルを一度リセット
    $pdo->exec("TRUNCATE TABLE categories");

    $categories = [
        // 収入 (income)
        ['給与', 'income'], ['賞与', 'income'], ['年金・手当', 'income'], 
        ['事業収入', 'income'], ['還付金', 'income'], ['臨時収入', 'income'], ['その他収入', 'income'],
        // 支出 (expense)
        ['食費', 'expense'], ['住居費', 'expense'], ['電気代', 'expense'], 
        ['ガス代', 'expense'], ['水道代', 'expense'], ['通信費', 'expense'], 
        ['サブスク', 'expense'], // ← 新聞・NHKから変更
        ['保険料', 'expense'], ['医療費', 'expense'], 
        ['交通費', 'expense'], ['被服費', 'expense'], ['日用品費', 'expense'], 
        ['交際費', 'expense'], ['娯楽費', 'expense'], ['教育費', 'expense'], 
        ['仕送り', 'expense'], ['返済(公租公課等)', 'expense'], ['雑費', 'expense']
    ];

    $st = $pdo->prepare("INSERT INTO categories (category_name, type) VALUES (?, ?)");
    foreach ($categories as $cat) {
        $st->execute($cat);
    }

    echo "科目を「サブスク」を含む最新リストに更新しました！<br><a href='index.php'>戻る</a>";
} catch (Exception $e) {
    echo "エラー: " . $e->getMessage();
}