<?php
require_once 'db.php';

$message = '';
$lock_key = 'HATABOW'; // 実行用キーワード

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input_key = $_POST['input_key'] ?? '';

    if ($input_key === $lock_key) {
        // 設定したい新しいパスワード
        $new_plain_password = 'admin123';
        $hashed_password = password_hash($new_plain_password, PASSWORD_DEFAULT);

        try {
            $st = $pdo->prepare("UPDATE users SET password = ? WHERE user_code = 'admin'");
            $st->execute([$hashed_password]);

            if ($st->rowCount() > 0) {
                $message = "<div class='alert alert-success'><strong>成功：</strong> adminのパスワードを「 {$new_plain_password} 」にリセットしました。</div>";
                $message .= "<p class='text-danger fw-bold'>【重要】このファイルを今すぐサーバーから削除してください！</p>";
            } else {
                $message = "<div class='alert alert-warning'>警告：adminユーザーが見つからないか、既にパスワードが同じです。</div>";
            }
        } catch (PDOException $e) {
            $message = "<div class='alert alert-danger'>エラー： " . htmlspecialchars($e->getMessage()) . "</div>";
        }
    } else {
        $message = "<div class='alert alert-danger'>キーワードが正しくありません。実行を拒否しました。</div>";
    }
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>緊急パスワードリセット</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8d7da; padding-top: 50px; }
        .reset-box { max-width: 500px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 4px 10px rgba(0,0,0,0.2); }
    </style>
</head>
<body>

<div class="container">
    <div class="reset-box">
        <h4 class="text-danger text-center mb-4">管理者パスワード強制リセット</h4>
        
        <?= $message ?>

        <?php if (!isset($st) || $st->rowCount() == 0): ?>
            <p class="small text-muted">実行するには、指定されたキーワードを入力してください。</p>
            <form method="POST">
                <div class="mb-3">
                    <input type="text" name="input_key" class="form-control" placeholder="キーワードを入力" required>
                </div>
                <button type="submit" class="btn btn-danger w-100">adminのパスワードを admin123 に戻す</button>
            </form>
        <?php endif; ?>

        <div class="text-center mt-4">
            <a href="login.php" class="text-decoration-none">ログイン画面へ</a>
        </div>
    </div>
</div>

</body>
</html>