<?php
// エラー表示を一時的に有効化（原因特定のため）
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once 'db.php';
check_login();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 1. 各パラメータを安全に取得
    $debtor_id   = $_POST['debtor_id'] ?? $_SESSION['debtor_id'] ?? null;
    $user_code   = $_POST['user_code'] ?? $_SESSION['user_code'] ?? '0000';
    $category_id = $_POST['category_id'] ?? null;
    $amount      = $_POST['amount'] ?? 0;
    $date        = $_POST['date'] ?? date('Y-m-d');
    $memo        = $_POST['memo'] ?? '';
    $image_path  = null;

    // リダイレクト先URLの決定
    $back_url = (isset($_SESSION['role']) && $_SESSION['role'] === 'admin') ? "index.php" : "home.php";

    // 必須チェック：IDやカテゴリがない場合は登録せずに戻す
    if (!$debtor_id || !$category_id) {
        header("Location: " . $back_url);
        exit;
    }

    // 2. 二重送信防止
    $st_check = $pdo->prepare("SELECT id FROM transactions WHERE debtor_id = ? AND amount = ? AND category_id = ? AND date = ? AND memo = ? ORDER BY id DESC LIMIT 1");
    $st_check->execute([$debtor_id, $amount, $category_id, $date, $memo]);
    if ($st_check->fetch()) {
        header("Location: " . $back_url);
        exit;
    }

    // 3. 画像アップロード処理
    if (isset($_FILES['image']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {
        $upload_dir = 'uploads/';
        if (!is_dir($upload_dir)) {
            mkdir($upload_dir, 0777, true);
        }
        $ext = pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION);
        $filename = uniqid('img_', true) . '.' . $ext;
        $target = $upload_dir . $filename;
        if (move_uploaded_file($_FILES['image']['tmp_name'], $target)) {
            $image_path = $target;
        }
    }

    // 4. データベース登録
    try {
        $st = $pdo->prepare("INSERT INTO transactions (debtor_id, user_code, category_id, amount, date, memo, image_path) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $st->execute([$debtor_id, $user_code, $category_id, $amount, $date, $memo, $image_path]);
    } catch (PDOException $e) {
        // デバッグ用：データベースエラーが出た場合は画面に表示
        die("DB Error: " . $e->getMessage());
    }

    // 5. 完了後のリダイレクト
    header("Location: " . $back_url);
    exit;
} else {
    // POST以外でアクセスされた場合も戻す
    $back_url = (isset($_SESSION['role']) && $_SESSION['role'] === 'admin') ? "index.php" : "home.php";
    header("Location: " . $back_url);
    exit;
}