<?php
require_once 'db.php'; check_login();
if ($_SESSION['role'] !== 'admin') { header('Location: index.php'); exit; }

$msg = ""; $new_info = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $base_name = $_POST['name'];
    $pay_day = (int)$_POST['pay_day'];
    $pass_raw = !empty($_POST['custom_pass']) ? $_POST['custom_pass'] : "pass1234";
    $pass_hash = password_hash($pass_raw, PASSWORD_DEFAULT);

    try {
        $pdo->beginTransaction();
        $st1 = $pdo->prepare("INSERT INTO debtors (name, pay_day) VALUES (?, ?)");
        $st1->execute([$base_name, $pay_day]);
        
        $did_int = $pdo->lastInsertId();
        $did = str_pad($did_int, 4, '0', STR_PAD_LEFT); 

        $st2 = $pdo->prepare("INSERT INTO users (user_code, debtor_id, user_name, password, role) VALUES (?, ?, ?, ?, 'user')");
        $st2->execute([$did . '1', $did, $base_name . '（本人）', $pass_hash]);
        $st3 = $pdo->prepare("INSERT INTO users (user_code, debtor_id, user_name, password, role) VALUES (?, ?, ?, ?, 'user')");
        $st3->execute([$did . '2', $did, $base_name . '（配偶者）', $pass_hash]);

        $pdo->commit();
        $new_info = ['did' => $did, 'name' => $base_name, 'pass' => $pass_raw, 'pay_day' => $pay_day];
    } catch (Exception $e) { $pdo->rollBack(); $msg = "登録エラー: " . $e->getMessage(); }
}
?>
<!DOCTYPE html>
<html lang="ja"><head><meta charset="UTF-8"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"></head>
<body class="bg-light"><div class="container mt-5" style="max-width:500px;"><div class="card p-4 shadow">
    <h5 class="fw-bold text-danger">新規債務者の登録</h5>
    <?php if ($new_info): ?>
        <div class="alert alert-success">登録完了！ ID: <?= $new_info['did'] ?>1 / 2<br>起算日: 毎月 <?= $new_info['pay_day'] ?> 日</div>
        <a href="register_debtor.php" class="btn btn-outline-danger w-100">続けて登録</a>
    <?php else: ?>
        <form method="POST">
            <div class="mb-3"><label class="small fw-bold">氏名</label><input type="text" name="name" class="form-control" required></div>
            <div class="mb-3">
                <label class="small fw-bold">給料日（起算日）</label>
                <select name="pay_day" class="form-select">
                    <?php for($i=1;$i<=28;$i++) echo "<option value='$i'>$i 日</option>"; ?>
                </select>
                <div class="form-text small">この日から翌月の前日までを1ヶ月として集計します</div>
            </div>
            <div class="mb-3"><label class="small fw-bold">パスワード</label><input type="text" name="custom_pass" class="form-control" placeholder="pass1234"></div>
            <button type="submit" class="btn btn-danger w-100">登録</button>
        </form>
    <?php endif; ?>
    <a href="index.php" class="btn btn-link w-100 mt-2 text-secondary">戻る</a>
</div></div></body></html>