<?php
require_once 'db.php';
check_login();

// 弁護士（管理者）以外はアクセス禁止
if ($_SESSION['role'] !== 'admin') {
    exit('権限がありません');
}

$target_did = $_GET['did'] ?? '';
if (!$target_did) {
    exit('債務者IDが指定されていません');
}

$msg = "";

// --- 債務者名の取得 ---
$st_n = $pdo->prepare("SELECT name FROM debtors WHERE debtor_id = ?");
$st_n->execute([$target_did]);
$debtor = $st_n->fetch();

// --- 追加処理 ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_cat'])) {
    $name = $_POST['name'];
    $type = $_POST['type'];
    // チェックが入っていれば1（合算）、なければ0（個別）
    $is_combined = isset($_POST['is_combined']) ? 1 : 0;

    if (!empty($name)) {
        $st = $pdo->prepare("INSERT INTO categories (debtor_id, category_name, type, is_combined) VALUES (?, ?, ?, ?)");
        $st->execute([$target_did, $name, $type, $is_combined]);
        $msg = "専用科目「" . htmlspecialchars($name) . "」を追加しました。";
    }
}

// --- 削除処理（この世帯の専用科目のみ削除可能） ---
if (isset($_GET['del'])) {
    $st = $pdo->prepare("DELETE FROM categories WHERE category_id = ? AND debtor_id = ?");
    $st->execute([$_GET['del'], $target_did]);
    header("Location: manage_debtor_categories.php?did=" . $target_did);
    exit;
}

// --- 一覧の取得（共通科目 + この世帯の専用科目） ---
$st = $pdo->prepare("
    SELECT * FROM categories 
    WHERE debtor_id = '0000' OR debtor_id = ? 
    ORDER BY debtor_id ASC, type DESC, category_id ASC
");
$st->execute([$target_did]);
$list = $st->fetchAll();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>世帯別科目管理</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f8f9fa; }
        .main-container { max-width: 900px; margin: 30px auto; }
        .card { border-radius: 12px; border: none; }
        .badge-common { background-color: #6c757d; color: white; }
        .badge-special { background-color: #dc3545; color: white; }
    </style>
</head>
<body>

<div class="container main-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold mb-0"><?= htmlspecialchars($debtor['name']) ?> 様 専用科目管理</h4>
            <small class="text-muted">共通科目に加え、この世帯特有の科目を追加・設定できます</small>
        </div>
        <a href="index.php" class="btn btn-secondary btn-sm">戻る</a>
    </div>

    <?php if($msg): ?>
        <div class="alert alert-success shadow-sm"><?= $msg ?></div>
    <?php endif; ?>

    <div class="card shadow-sm mb-4">
        <div class="card-body p-4">
            <h6 class="fw-bold text-danger mb-3">新しい専用科目を追加する</h6>
            <form method="POST" class="row g-3 align-items-end">
                <input type="hidden" name="add_cat" value="1">
                <div class="col-md-4">
                    <label class="form-label small fw-bold">科目名（例：猫の餌代、〇〇クリニック）</label>
                    <input type="text" name="name" class="form-control" placeholder="科目名を入力" required>
                </div>
                <div class="col-md-2">
                    <label class="form-label small fw-bold">区分</label>
                    <select name="type" class="form-select">
                        <option value="expense">支出</option>
                        <option value="income">収入</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="is_combined" id="check_combined" checked>
                        <label class="form-check-label small fw-bold" for="check_combined">
                            世帯で合算して集計する
                        </label>
                    </div>
                    <div class="text-muted" style="font-size: 0.7rem;">※チェックを外すと本人・配偶者別に集計されます</div>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-danger w-100 fw-bold">追加する</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th style="width: 15%">種類</th>
                        <th style="width: 15%">区分</th>
                        <th style="width: 30%">科目名</th>
                        <th style="width: 25%">集計ルール</th>
                        <th style="width: 15%" class="text-center">操作</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($list as $c): ?>
                    <tr>
                        <td>
                            <?= $c['debtor_id'] === '0000' ? 
                                '<span class="badge badge-common">共通</span>' : 
                                '<span class="badge badge-special">専用</span>' ?>
                        </td>
                        <td>
                            <?= $c['type'] === 'income' ? '<span class="text-primary">収入</span>' : '<span class="text-danger">支出</span>' ?>
                        </td>
                        <td class="fw-bold"><?= htmlspecialchars($c['category_name']) ?></td>
                        <td>
                            <?php if($c['is_combined']): ?>
                                <span class="text-success small">● 世帯合算</span>
                            <?php else: ?>
                                <span class="text-warning small">▲ 本人・配偶者別</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <?php if($c['debtor_id'] !== '0000'): ?>
                                <a href="?did=<?= $target_did ?>&del=<?= $c['category_id'] ?>" 
                                   class="btn btn-sm btn-link text-danger" 
                                   onclick="return confirm('この専用科目を削除しますか？')">削除</a>
                            <?php else: ?>
                                <small class="text-muted">（共通）</small>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>