<?php
require_once 'db.php';
check_login();

if ($_SESSION['role'] !== 'admin') {
    exit('権限がありません');
}

$msg = "";

// --- 並び替え処理 ---
if (isset($_GET['move']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $direction = $_GET['move'];

    // 【重要】もし全員 0 なら、現在の表示順で連番(10, 20...)を振り直す初期化
    $check = $pdo->query("SELECT COUNT(*) FROM categories WHERE debtor_id = '0000' AND sort_order <> 0")->fetchColumn();
    if ($check == 0) {
        $all = $pdo->query("SELECT category_id FROM categories WHERE debtor_id = '0000' ORDER BY type DESC, category_id ASC")->fetchAll();
        foreach ($all as $idx => $row) {
            $pdo->prepare("UPDATE categories SET sort_order = ? WHERE category_id = ?")->execute([($idx + 1) * 10, $row['category_id']]);
        }
    }
    
    // 現在の項目の順序を取得
    $st = $pdo->prepare("SELECT sort_order FROM categories WHERE category_id = ?");
    $st->execute([$id]);
    $current = $st->fetch();

    if ($current) {
        $curr_order = $current['sort_order'];
        
        if ($direction === 'up') {
            // 一つ上の項目を探す
            $st = $pdo->prepare("SELECT category_id, sort_order FROM categories WHERE debtor_id = '0000' AND sort_order < ? ORDER BY sort_order DESC LIMIT 1");
        } else {
            // 一つ下の項目を探す
            $st = $pdo->prepare("SELECT category_id, sort_order FROM categories WHERE debtor_id = '0000' AND sort_order > ? ORDER BY sort_order ASC LIMIT 1");
        }
        
        $st->execute([$curr_order]);
        $target = $st->fetch();

        if ($target) {
            // 順序を入れ替える
            $pdo->prepare("UPDATE categories SET sort_order = ? WHERE category_id = ?")->execute([$target['sort_order'], $id]);
            $pdo->prepare("UPDATE categories SET sort_order = ? WHERE category_id = ?")->execute([$curr_order, $target['category_id']]);
        }
    }
    header('Location: manage_categories.php');
    exit;
}

// --- 削除処理 ---
if (isset($_GET['del'])) {
    $st = $pdo->prepare("DELETE FROM categories WHERE category_id = ? AND debtor_id = '0000'");
    $st->execute([$_GET['del']]);
    header('Location: manage_categories.php');
    exit;
}

// --- 追加・編集処理 ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['category_name'];
    $type = $_POST['type'];
    $is_combined = isset($_POST['is_combined']) ? 1 : 0;

    if (!empty($_POST['category_id'])) {
        $st = $pdo->prepare("UPDATE categories SET category_name = ?, type = ?, is_combined = ? WHERE category_id = ? AND debtor_id = '0000'");
        $st->execute([$name, $type, $is_combined, $_POST['category_id']]);
        $msg = "更新しました";
    } else {
        $st = $pdo->query("SELECT MAX(sort_order) FROM categories WHERE debtor_id = '0000'");
        $max = $st->fetchColumn() ?: 0;
        $st = $pdo->prepare("INSERT INTO categories (category_name, type, is_combined, debtor_id, sort_order) VALUES (?, ?, ?, '0000', ?)");
        $st->execute([$name, $type, $is_combined, $max + 10]);
        $msg = "追加しました";
    }
}

// --- 一覧の取得 (sort_order 順) ---
$sql = "SELECT * FROM categories WHERE debtor_id = '0000' ORDER BY sort_order ASC, category_id ASC";
$st = $pdo->query($sql);
$list = $st->fetchAll();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>共通科目管理</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { background-color: #f8f9fa; }
        .main-container { max-width: 900px; margin: 30px auto; }
        .table-card { border-radius: 12px; border: none; background: #fff; }
        .form-card { border-radius: 12px; border: none; background: #fff; margin-bottom: 20px; }
        .btn-move { padding: 0.2rem 0.5rem; color: #6c757d; }
        .btn-move:hover { color: #0d6efd; background: #f0f7ff; }
    </style>
</head>
<body>

<div class="container main-container">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold mb-0">共通科目・合算設定</h4>
        <a href="index.php" class="btn btn-secondary btn-sm shadow-sm">管理メニューへ戻る</a>
    </div>

    <?php if($msg): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= htmlspecialchars($msg) ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card shadow-sm form-card border-top border-primary border-4">
        <div class="card-body p-4">
            <h6 class="fw-bold text-primary mb-3" id="form-title">科目の追加</h6>
            <form method="POST" id="edit-form" class="row g-3">
                <input type="hidden" name="category_id" id="edit_id">
                <div class="col-md-5">
                    <label class="form-label small fw-bold">科目名</label>
                    <input type="text" name="category_name" id="edit_name" class="form-control" placeholder="例：通信費" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label small fw-bold">収支区分</label>
                    <select name="type" id="edit_type" class="form-select">
                        <option value="expense">支出（マイナス）</option>
                        <option value="income">収入（プラス）</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" name="is_combined" id="edit_combined" checked>
                        <label class="form-check-label small fw-bold" for="edit_combined">世帯で合算して集計</label>
                    </div>
                </div>
                <div class="col-12 mt-3 d-flex gap-2">
                    <button type="submit" class="btn btn-primary px-4 fw-bold">保存する</button>
                    <button type="button" id="cancel-btn" class="btn btn-outline-secondary px-4 d-none" onclick="resetForm()">キャンセル</button>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow-sm table-card">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0">
                <thead class="table-light">
                    <tr>
                        <th style="width: 80px;" class="text-center">移動</th>
                        <th style="width: 15%">区分</th>
                        <th>科目名</th>
                        <th style="width: 20%">集計方法</th>
                        <th style="width: 160px;" class="text-center">操作</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($list as $c): ?>
                    <tr>
                        <td class="text-center">
                            <div class="d-flex flex-column">
                                <a href="?move=up&id=<?= $c['category_id'] ?>" class="btn-move text-decoration-none"><i class="bi bi-caret-up-fill"></i></a>
                                <a href="?move=down&id=<?= $c['category_id'] ?>" class="btn-move text-decoration-none"><i class="bi bi-caret-down-fill"></i></a>
                            </div>
                        </td>
                        <td>
                            <?= $c['type'] === 'income' ? '<span class="badge bg-primary">収入</span>' : '<span class="badge bg-danger">支出</span>' ?>
                        </td>
                        <td class="fw-bold"><?= htmlspecialchars($c['category_name']) ?></td>
                        <td>
                            <?php if($c['is_combined']): ?>
                                <span class="text-success small">● 世帯合算</span>
                            <?php else: ?>
                                <span class="text-warning small">▲ 本人配偶者別</span>
                            <?php endif; ?>
                        </td>
                        <td class="text-center">
                            <button type="button" class="btn btn-sm btn-outline-primary" 
                                    onclick="setEditMode('<?= $c['category_id'] ?>','<?= htmlspecialchars($c['category_name']) ?>','<?= $c['type'] ?>', <?= $c['is_combined'] ?>)">編集</button>
                            <a href="?del=<?= $c['category_id'] ?>" class="btn btn-sm text-danger text-decoration-none ms-2" onclick="return confirm('削除しますか？')">削除</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function setEditMode(id, name, type, combined) {
    document.getElementById('form-title').innerText = "科目を編集モード";
    document.getElementById('edit_id').value = id;
    document.getElementById('edit_name').value = name;
    document.getElementById('edit_type').value = type;
    document.getElementById('edit_combined').checked = (combined == 1);
    document.getElementById('cancel-btn').classList.remove('d-none');
    window.scrollTo({ top: 0, behavior: 'smooth' });
}
function resetForm() {
    document.getElementById('form-title').innerText = "科目の追加";
    document.getElementById('edit_id').value = "";
    document.getElementById('edit_name').value = "";
    document.getElementById('cancel-btn').classList.add('d-none');
}
</script>
</body>
</html>