<?php
require_once 'db.php';

// セッションの開始（既に開始されている場合はスキップ）
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$error = "";

// フォームが送信された場合
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_code = $_POST['user_code'] ?? '';
    $password = $_POST['password'] ?? '';

    // ユーザー情報の取得
    $st = $pdo->prepare("SELECT * FROM users WHERE user_code = ?");
    $st->execute([$user_code]);
    $user = $st->fetch();

    // 認証チェック
    if ($user && password_verify($password, $user['password'])) {
        // セッションの再生成（セキュリティ対策：セッションハイジャック防止）
        session_regenerate_id(true);

        // セッションに必要な情報を保存
        $_SESSION['user_code'] = $user['user_code'];
        $_SESSION['role']      = $user['role'];      // 'admin' または 'debtor'
        $_SESSION['debtor_id'] = $user['debtor_id']; // 債務者世帯ID
        $_SESSION['user_name'] = $user['user_name']; // 表示用名前

        // セッションを即時保存
        session_write_close();

        // 役割に応じたリダイレクト
        if ($user['role'] === 'admin') {
            header('Location: index.php');
        } else {
            // 債務者はリッチなポータル画面へ
            header('Location: home.php');
        }
        exit;
    } else {
        $error = "ユーザーIDまたはパスワードが正しくありません。";
    }
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>ログイン | 家計管理システム</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f0f2f5;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .login-card {
            width: 100%;
            max-width: 400px;
            border: none;
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.1);
        }
        .btn-login {
            padding: 0.8rem;
            font-weight: bold;
            border-radius: 0.5rem;
        }
    </style>
</head>
<body>

<div class="container px-4">
    <div class="card login-card mx-auto">
        <div class="card-body p-5">
            <div class="text-center mb-4">
                <h4 class="fw-bold">家計管理システム</h4>
                <p class="text-muted small">ログインして入力・確認を行ってください</p>
            </div>

            <?php if ($error): ?>
                <div class="alert alert-danger small py-2" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="POST" action="login.php">
                <div class="mb-3">
                    <label class="form-label small fw-bold">ユーザーID</label>
                    <input type="text" name="user_code" class="form-control form-control-lg" placeholder="例: 10011" required autofocus>
                </div>
                
                <div class="mb-4">
                    <label class="form-label small fw-bold">パスワード</label>
                    <input type="password" name="password" class="form-control form-control-lg" placeholder="••••••••" required>
                </div>

                <div class="d-grid shadow-sm">
                    <button type="submit" class="btn btn-primary btn-login">
                        ログイン
                    </button>
                </div>
            </form>
        </div>
    </div>
    
    <div class="text-center mt-4 text-muted small">
        &copy; 2026 Household Management System
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>