<?php
// --- セルフチェック機能 ---
$required_files = [
    'change_admin_password.php',
    'input.php',
    'change_password.php',
    'db_backup_single.php',
    'login.php',
    'db_backup.php',
    'logout.php',
    'db_restore.php',
    'manage_categories.php',
    'db.php',
    'manage_debtor_categories.php',
    'delete_debtor.php',
    'register_debtor.php',
    'delete_transaction.php',
    'register_transaction.php',
    'edit_debtor.php',
    'reset_admin.php',
    'edit_transaction.php',
    'update_categories.php',
    'home.php',
    'view_report.php',
    'index.php'
];

$missing_files = [];
foreach ($required_files as $f) {
    if (!file_exists($f)) {
        $missing_files[] = $f;
    }
}

$is_not_writable = !is_writable('./');

if (!empty($missing_files) || $is_not_writable) {
    echo '<!DOCTYPE html><html lang="ja"><body>';
    echo '<div style="margin:20px; padding:20px; border:3px solid #dc3545; background-color:#fff5f5; border-radius:10px; font-family:sans-serif;">';
    echo '<h3 style="color:#dc3545;">⚠️ インストール前の確認エラー</h3>';

    if (!empty($missing_files)) {
        echo '<p><strong>以下のファイルが不足しています：</strong></p>';
        echo '<ul style="color:#555;"><li>' . implode('</li><li>', $missing_files) . '</li></ul>';
    }

    if ($is_not_writable) {
        echo '<p style="color:#dc3545;"><strong>【重要】書き込み権限エラー：</strong><br>';
        echo 'サーバーの設定により、フォルダの自動作成ができません。手動で <code>uploads</code> フォルダを作成し、そのフォルダに書き込み権限（777等）を与えてください。</p>';
    }

    echo '<p style="margin-top:20px; background:#eee; padding:10px; border-radius:5px;">';
    echo '<strong>解決策：</strong> 一度サーバー上のファイルをすべて削除し、お手元の<strong>ZIPファイルをそのままアップロード</strong>してから、サーバーの機能で「解凍（展開）」を行ってください。';
    echo '</p>';
    echo '</div></body></html>';
    exit;
}
// --- セルフチェック終了 ---

ini_set('display_errors', 1);
error_reporting(E_ALL);
session_start();
$success = false; $msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host = $_POST['host']; $dbname = $_POST['dbname']; $dbuser = $_POST['dbuser']; $dbpass = $_POST['dbpass'];
    try {
        $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $dbuser, $dbpass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $upload_dir = 'uploads';
        if (!is_dir($upload_dir)) {
            if (!mkdir($upload_dir, 0777, true)) {
                throw new Exception("ディレクトリ {$upload_dir} の作成に失敗しました。");
            }
        }
        chmod($upload_dir, 0777);

        $config_content = "<?php\ndefine('DB_HOST', '$host');\ndefine('DB_NAME', '$dbname');\ndefine('DB_USER', '$dbuser');\ndefine('DB_PASS', '$dbpass');\n?>";
        file_put_contents('config.php', $config_content);

        $pdo->exec("SET FOREIGN_KEY_CHECKS = 0;");
        $tables = ['transactions', 'categories', 'users', 'debtors'];
        foreach ($tables as $table) { $pdo->exec("DROP TABLE IF EXISTS $table"); }

        $queries = [
            "CREATE TABLE debtors (debtor_id int(4) UNSIGNED ZEROFILL NOT NULL PRIMARY KEY AUTO_INCREMENT, name varchar(50) NOT NULL, pay_day int(11) DEFAULT 1, created_at datetime DEFAULT current_timestamp(), initial_balance int(11) DEFAULT 0, cutoff_date int(11) DEFAULT 25) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
            "CREATE TABLE users (user_code varchar(10) NOT NULL PRIMARY KEY, debtor_id int(4) UNSIGNED ZEROFILL NOT NULL, user_name varchar(100) NOT NULL, password varchar(255) NOT NULL, role enum('admin','user') DEFAULT 'user') ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
            "CREATE TABLE categories (category_id int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT, debtor_id int(4) UNSIGNED ZEROFILL NOT NULL DEFAULT 0000, category_name varchar(50) NOT NULL, type enum('income','expense') NOT NULL, is_combined tinyint(1) DEFAULT 1, sort_order int(11) DEFAULT 0) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4",
            "CREATE TABLE transactions (id int(11) NOT NULL PRIMARY KEY AUTO_INCREMENT, debtor_id int(4) UNSIGNED ZEROFILL NOT NULL, user_code varchar(10) NOT NULL, date date NOT NULL, category_id int(11) NOT NULL, amount int(11) NOT NULL, memo text DEFAULT NULL, image_path varchar(255) DEFAULT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4"
        ];
        foreach ($queries as $q) { $pdo->exec($q); }

        $pdo->exec("INSERT INTO debtors (debtor_id, name) VALUES ('0000', 'システム管理者')");
        $hash = password_hash('admin123', PASSWORD_DEFAULT);
        $st = $pdo->prepare("INSERT INTO users (user_code, debtor_id, user_name, password, role) VALUES (?, ?, ?, ?, ?)");
        $st->execute(['admin', '0000', '弁護士 先生', $hash, 'admin']);

        $categories = [
            [1, '0000', '給与', 'income', 0, 10], [2, '0000', '賞与', 'income', 0, 20],
            [3, '0000', '年金・手当', 'income', 0, 30], [4, '0000', '事業収入', 'income', 0, 40],
            [5, '0000', '臨時収入', 'income', 0, 50], [6, '0000', '還付金', 'income', 0, 60],
            [7, '0000', 'その他収入', 'income', 0, 70], [8, '0000', '住居費', 'expense', 1, 80],
            [9, '0000', '駐車場代', 'expense', 1, 90], [10, '0000', '電気代', 'expense', 1, 100],
            [11, '0000', 'ガス代', 'expense', 1, 110], [12, '0000', '水道代', 'expense', 1, 120],
            [13, '0000', '保険料', 'expense', 1, 130], [14, '0000', '通信費', 'expense', 1, 140],
            [15, '0000', '食費', 'expense', 1, 150], [16, '0000', '教育費', 'expense', 1, 160],
            [17, '0000', '交通費', 'expense', 1, 170], [18, '0000', '医療費', 'expense', 1, 180],
            [19, '0000', '日用品費', 'expense', 1, 190], [20, '0000', 'サブスク', 'expense', 0, 200],
            [21, '0000', '車両関連', 'expense', 0, 210], [22, '0000', '被服費', 'expense', 0, 220],
            [23, '0000', '交際費', 'expense', 0, 230], [24, '0000', '嗜好品代', 'expense', 0, 240],
            [25, '0000', '娯楽費', 'expense', 0, 250], [26, '0000', '雑費', 'expense', 1, 260],
            [27, '0000', '返済(公租公課等)', 'expense', 0, 270], [28, '0000', '返済（その他）', 'expense', 0, 280]
        ];
        $stc = $pdo->prepare("INSERT INTO categories (category_id, debtor_id, category_name, type, is_combined, sort_order) VALUES (?, ?, ?, ?, ?, ?)");
        foreach ($categories as $c) { $stc->execute($c); }
        $pdo->exec("ALTER TABLE categories AUTO_INCREMENT = 32");
        $pdo->exec("SET FOREIGN_KEY_CHECKS = 1;");

        // --- 管理者へのインストール完了通知メール ---
        $your_email = "master@hatabow.com";
        $site_url = (empty($_SERVER['HTTPS']) ? 'http://' : 'https://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
        $mail_subject = "【家計管理システム】新しいセットアップが完了しました";
        $mail_body = "システムが新しくインストールされました。\n\n"
                   . "■実行日時: " . date('Y-m-d H:i:s') . "\n"
                   . "■設置URL: " . $site_url . "\n"
                   . "■DB名: " . $dbname . "\n\n"
                   . "※このメールは install.php から自動送信されています。";
        $from_email = "no-reply@" . $_SERVER['HTTP_HOST'];
        $headers = "From: " . $from_email;
        mb_language("Japanese");
        mb_internal_encoding("UTF-8");
        @mb_send_mail($your_email, $mail_subject, $mail_body, $headers);

        // --- セキュリティ対策: 完了後に自身をリネーム ---
        $currentFile = __FILE__;
        $newName = 'installed_' . date('YmdHis') . '.php.bak';
        @rename($currentFile, $newName);

        $msg = "セットアップが正常に完了しました。<br>セキュリティのため、このファイルは自動的に <b>{$newName}</b> へリネームされました。";
        $success = true;
    } catch (Exception $e) { $msg = "エラー: " . $e->getMessage(); }
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>システムセットアップ</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5" style="max-width:500px;">
        <div class="card p-4 shadow-lg border-0">
            <h4 class="text-center fw-bold mb-4 text-primary">System Setup</h4>
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <p class="mb-0"><?php echo $msg; ?></p>
                    <hr>
                    <p class="small text-muted">ログイン情報:<br>ユーザー名: admin / パスワード: admin123</p>
                    <a href="login.php" class="btn btn-success w-100 mt-2">ログイン画面へ</a>
                </div>
            <?php else: ?>
                <?php if ($msg): ?><div class="alert alert-danger"><?php echo $msg; ?></div><?php endif; ?>
                <p class="small text-secondary mb-4">データベース情報を入力して「実行」ボタンを押してください。既存のデータはすべて上書きされます。</p>
                <form method="POST">
                    <div class="mb-3"><label class="form-label small fw-bold">DBホスト名</label><input type="text" name="host" class="form-control" value="localhost"></div>
                    <div class="mb-3"><label class="form-label small fw-bold">データベース名</label><input type="text" name="dbname" class="form-control" required placeholder="例: database_name"></div>
                    <div class="mb-3"><label class="form-label small fw-bold">ユーザー名</label><input type="text" name="dbuser" class="form-control" required placeholder="例: db_user"></div>
                    <div class="mb-3"><label class="form-label small fw-bold">パスワード</label><input type="password" name="dbpass" class="form-control"></div>
                    <button type="submit" class="btn btn-dark w-100 py-2 fw-bold">セットアップを実行する</button>
                </form>
            <?php endif; ?>
        </div>
        <div class="text-center mt-3 text-muted" style="font-size: 0.8rem;">&copy; 2026 Management System</div>
    </div>
</body>
</html>