<?php
require_once 'db.php';
check_login();

$msg = "";
$user_code = $_SESSION['user_code'];
$did = $_SESSION['debtor_id'];

// --- 保存処理 ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date = $_POST['date'];
    $cat_id = $_POST['category_id'];
    $amount = (int)$_POST['amount'];
    $memo = $_POST['memo'];

    if ($amount > 0) {
        $st = $pdo->prepare("INSERT INTO transactions (debtor_id, user_code, date, category_id, amount, memo) VALUES (?, ?, ?, ?, ?, ?)");
        $st->execute([$did, $user_code, $date, $cat_id, $amount, $memo]);
        $msg = "記録しました！";
    }
}

// --- プルダウン用科目の取得 ---
// 1. 共通科目(0000) と 2. この世帯専用の科目(did) を両方取得
$st = $pdo->prepare("SELECT * FROM categories WHERE debtor_id = '0000' OR debtor_id = ? ORDER BY type DESC, category_id ASC");
$st->execute([$did]);
$categories = $st->fetchAll();

// 直近の入力履歴（5件）
$st_h = $pdo->prepare("
    SELECT t.*, c.category_name 
    FROM transactions t 
    JOIN categories c ON t.category_id = c.category_id 
    WHERE t.debtor_id = ? 
    ORDER BY t.id DESC LIMIT 5
");
$st_h->execute([$did]);
$history = $st_h->fetchAll();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>収支入力</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f0f2f5; font-size: 16px; }
        .input-card { max-width: 500px; margin: 20px auto; border-radius: 15px; border: none; }
        .btn-submit { padding: 12px; font-weight: bold; border-radius: 10px; }
        .history-card { max-width: 500px; margin: 0 auto; border-radius: 15px; border: none; }
    </style>
</head>
<body>
<nav class="navbar navbar-dark bg-primary shadow-sm mb-3">
    <div class="container">
        <span class="navbar-brand mb-0 h1">家計簿入力</span>
        <a href="index.php" class="btn btn-outline-light btn-sm">戻る</a>
    </div>
</nav>

<div class="container">
    <?php if($msg): ?>
        <div class="alert alert-success shadow-sm alert-dismissible fade show">
            <?= $msg ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card input-card shadow-sm">
        <div class="card-body p-4">
            <form method="POST">
                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">日付</label>
                    <input type="date" name="date" class="form-control form-control-lg" value="<?= date('Y-m-d') ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">項目（カテゴリ）</label>
                    <select name="category_id" class="form-select form-select-lg" required>
                        <option value="">選択してください</option>
                        <optgroup label="【収入】">
                            <?php foreach($categories as $c): if($c['type'] !== 'income') continue; ?>
                                <option value="<?= $c['category_id'] ?>"><?= htmlspecialchars($c['category_name']) ?></option>
                            <?php endforeach; ?>
                        </optgroup>
                        <optgroup label="【支出】">
                            <?php foreach($categories as $c): if($c['type'] !== 'expense') continue; ?>
                                <option value="<?= $c['category_id'] ?>"><?= htmlspecialchars($c['category_name']) ?></option>
                            <?php endforeach; ?>
                        </optgroup>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label small fw-bold text-secondary">金額（円）</label>
                    <input type="number" name="amount" class="form-control form-control-lg" placeholder="0" inputmode="numeric" required>
                </div>

                <div class="mb-4">
                    <label class="form-label small fw-bold text-secondary">メモ（任意）</label>
                    <input type="text" name="memo" class="form-control" placeholder="〇〇スーパーなど">
                </div>

                <button type="submit" class="btn btn-primary btn-lg w-100 btn-submit shadow">この内容で登録する</button>
            </form>
        </div>
    </div>

    <div class="card history-card shadow-sm mb-5">
        <div class="card-header bg-white fw-bold small text-secondary">直近の入力（世帯共通）</div>
        <ul class="list-group list-group-flush">
            <?php foreach($history as $h): ?>
                <li class="list-group-item d-flex justify-content-between align-items-center">
                    <div>
                        <small class="text-muted d-block" style="font-size: 0.75rem;"><?= $h['date'] ?></small>
                        <span class="fw-bold"><?= htmlspecialchars($h['category_name']) ?></span>
                        <?php if($h['memo']): ?><small class="text-muted ms-1">（<?= htmlspecialchars($h['memo']) ?>）</small><?php endif; ?>
                    </div>
                    <span class="fw-bold <?= $h['amount'] > 0 ? 'text-dark' : '' ?>">
                        ¥<?= number_format($h['amount']) ?>
                    </span>
                </li>
            <?php endforeach; ?>
            <?php if(empty($history)): ?>
                <li class="list-group-item text-center text-muted small py-3">履歴はまだありません</li>
            <?php endif; ?>
        </ul>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>