<?php
require_once 'db.php';
check_login();

// 弁護士（管理者）以外はアクセス禁止
if ($_SESSION['role'] !== 'admin') {
    header("Location: home.php");
    exit;
}

// 債務者（世帯）一覧の取得
$st = $pdo->query("SELECT * FROM debtors WHERE debtor_id <> '0001' ORDER BY created_at DESC");
$debtors = $st->fetchAll();
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>管理者ダッシュボード | 家計管理システム</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { background-color: #f0f2f5; font-family: "Helvetica Neue", Arial, sans-serif; }
        .navbar { background-color: #2c3e50; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .main-container { max-width: 1100px; margin: 30px auto; }
        .card { border: none; border-radius: 12px; transition: transform 0.2s; }
        .debtor-card:hover { transform: translateY(-3px); }
        .btn-action { border-radius: 8px; font-weight: bold; font-size: 0.85rem; white-space: nowrap; padding: 0.5rem 0.75rem; }
        .config-card { background: linear-gradient(135deg, #fff 0%, #f8f9fa 100%); }
        .btn-action.disabled { pointer-events: none; opacity: 0.6; }
    </style>
</head>
<body>

<nav class="navbar navbar-expand-lg navbar-dark mb-4">
    <div class="container">
        <span class="navbar-brand fw-bold"><i class="bi bi-shield-lock-fill me-2"></i>管理者パネル</span>
        <div class="d-flex align-items-center">
            <span class="navbar-text me-3 text-white">管理者 様</span>
            <a href="change_admin_password.php" class="btn btn-outline-info btn-sm me-2">
                <i class="bi bi-key-fill me-1"></i>パスワード変更
            </a>
            <a href="logout.php" class="btn btn-outline-light btn-sm">ログアウト</a>
        </div>
    </div>
</nav>

<div class="container main-container">

    <div class="row mb-4 g-3">
        <div class="col-md-6">
            <div class="card h-100 shadow-sm border-start border-info border-5 config-card">
                <div class="card-body d-flex flex-column flex-sm-row justify-content-between align-items-sm-center gap-3">
                    <div>
                        <h6 class="mb-1 fw-bold text-info"><i class="bi bi-gear-fill me-2"></i>システム共通設定</h6>
                        <p class="text-muted small mb-0">全世帯共通の収支科目を管理します。</p>
                    </div>
                    <a href="manage_categories.php" class="btn btn-info btn-sm text-white fw-bold shadow-sm px-3 btn-action">共通科目設定</a>
                </div>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card h-100 shadow-sm border-start border-success border-5 config-card">
                <div class="card-body d-flex flex-column flex-sm-row justify-content-between align-items-sm-center gap-3">
                    <div>
                        <h6 class="mb-1 fw-bold text-success"><i class="bi bi-database-fill-down me-2"></i>データ管理</h6>
                        <p class="text-muted small mb-0">保存と復元を行います。</p>
                    </div>
                    <div class="d-flex flex-nowrap gap-2">
                        <a href="db_backup.php" class="btn btn-success btn-sm fw-bold shadow-sm px-3 btn-action">バックアップ</a>
                        <a href="db_restore.php" class="btn btn-danger btn-sm fw-bold shadow-sm px-3 btn-action">リストア</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-dark mb-0">管理対象世帯</h4>
        <a href="register_debtor.php" class="btn btn-dark btn-sm fw-bold shadow-sm">
            <i class="bi bi-person-plus-fill me-1"></i> 新規世帯登録
        </a>
    </div>

    <div class="row g-3">
        <?php foreach ($debtors as $d): ?>
        <div class="col-12">
            <div class="card shadow-sm debtor-card">
                <div class="card-body p-3">
                    <div class="row align-items-center">
                        <div class="col-xl-3 col-lg-12 mb-3 mb-xl-0">
                            <h5 class="fw-bold mb-1 text-dark"><?= htmlspecialchars($d['name']) ?> 様</h5>
                            <span class="badge bg-light text-dark border">ID: <?= htmlspecialchars($d['debtor_id']) ?></span>
                        </div>
                        <div class="col-xl-9 col-lg-12">
                            <div class="d-flex flex-wrap gap-2 justify-content-xl-end justify-content-start flex-nowrap">
                                <a href="view_report.php?debtor_id=<?= $d['debtor_id'] ?>" class="btn btn-outline-primary btn-action">
                                    <i class="bi bi-file-earmark-bar-graph"></i> 報告書
                                </a>
                                
                                <a href="db_backup_single.php?debtor_id=<?= $d['debtor_id'] ?>" class="btn btn-outline-success btn-action btn-backup">
                                    <i class="bi bi-download"></i> バックアップ
                                </a>
                                
                                <a href="manage_debtor_categories.php?did=<?= $d['debtor_id'] ?>" class="btn btn-outline-danger btn-action">
                                    <i class="bi bi-tags"></i> 専用科目
                                </a>
                                <a href="edit_debtor.php?did=<?= $d['debtor_id'] ?>" class="btn btn-outline-secondary btn-action">
                                    <i class="bi bi-pencil"></i> 編集
                                </a>
                                
                                <a href="change_password.php?debtor_id=<?= $d['debtor_id'] ?>" class="btn btn-outline-info btn-action">
                                    <i class="bi bi-key"></i> パスワード
                                </a>
                                
                                <a href="delete_debtor.php?debtor_id=<?= $d['debtor_id'] ?>" class="btn btn-outline-dark btn-action" onclick="return confirm('削除してもよろしいですか？')">
                                    <i class="bi bi-trash"></i> 削除
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
</div>

<script>
document.querySelectorAll('.btn-backup').forEach(button => {
    button.addEventListener('click', function(e) {
        // 1. 行から名前を取得
        const cardBody = this.closest('.card-body');
        const name = cardBody.querySelector('h5').innerText;

        // 2. 確認メッセージ
        if (!confirm(name + ' のデータをZIP保存します。よろしいですか？')) {
            e.preventDefault();
            return;
        }

        // 3. 視覚的なフィードバック（ボタンを「作成中」にする）
        const originalHTML = this.innerHTML;
        this.classList.add('disabled');
        this.innerHTML = '<span class="spinner-border spinner-border-sm me-1"></span> 作成中...';

        // 4. ダウンロード処理はバックグラウンドで走るので、5秒後に表示を元に戻す
        setTimeout(() => {
            this.classList.remove('disabled');
            this.innerHTML = originalHTML;
        }, 5000);
    });
});
</script>

</body>
</html>