<?php
require_once 'db.php';
check_login();

$did = $_SESSION['debtor_id'];
$display_name = $_SESSION['user_name'] ?? '利用者';

// 債務者情報の取得
$st_d = $pdo->prepare("SELECT name FROM debtors WHERE debtor_id = ?");
$st_d->execute([$did]);
$debtor = $st_d->fetch();

// 今月の収支計算
$target_month = date('Y-m');
$st_sum = $pdo->prepare("SELECT c.type, SUM(t.amount) as total FROM transactions t JOIN categories c ON t.category_id = c.category_id WHERE t.debtor_id = ? AND DATE_FORMAT(t.date, '%Y-%m') = ? GROUP BY c.type");
$st_sum->execute([$did, $target_month]);
$sums = $st_sum->fetchAll(PDO::FETCH_KEY_PAIR);
$income = $sums['income'] ?? 0;
$expense = $sums['expense'] ?? 0;
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>家計管理システム</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { background-color: #f4f7f6; font-family: "Meiryo", sans-serif; }
        .header-box { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 30px 20px; border-radius: 0 0 25px 25px; margin-bottom: 30px; }
        .info-card { background: white; border-radius: 15px; padding: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.05); margin-bottom: 20px; }
        .btn-custom { padding: 15px; border-radius: 12px; font-weight: bold; margin-bottom: 15px; display: flex; align-items: center; justify-content: center; text-decoration: none; border: none; width: 100%; }
        .btn-input-main { background-color: #007bff; color: white; }
        .btn-report-main { background-color: #28a745; color: white; }
        .modal-content { border-radius: 20px; }
        .form-label { font-weight: bold; margin-bottom: 5px; }
    </style>
</head>
<body>

<div class="header-box text-center shadow">
    <div class="h4 fw-bold mb-1"><?= htmlspecialchars($display_name) ?> 様</div>
    <div class="small opacity-75">家計管理システム</div>
    <a href="logout.php" class="btn btn-outline-light btn-sm mt-3 px-3 rounded-pill">ログアウト</a>
</div>

<div class="container">
    <div class="info-card row mx-1">
        <div class="col-6 text-center border-end">
            <div class="text-muted small">今月の収入</div>
            <div class="h5 fw-bold text-primary">¥<?= number_format($income) ?></div>
        </div>
        <div class="col-6 text-center">
            <div class="text-muted small">今月の支出</div>
            <div class="h5 fw-bold text-danger">¥<?= number_format($expense) ?></div>
        </div>
    </div>

    <div class="px-2">
        <button type="button" class="btn-custom btn-input-main shadow" data-bs-toggle="modal" data-bs-target="#inputModal">
             📝 明細を入力する
        </button>
        <a href="view_report.php" class="btn-custom btn-report-main shadow">
             📊 報告書を表示する
        </a>
    </div>
</div>

<div class="modal fade" id="inputModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header border-0">
                <h5 class="modal-title fw-bold">明細入力</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="inputForm">
                <div class="modal-body pt-0">
                    <div id="alertMsg" class="alert alert-success d-none py-2 mb-3 text-center small fw-bold">登録しました！続けて入力できます。</div>
                    
                    <input type="hidden" name="user_code" value="<?= htmlspecialchars($_SESSION['user_code']) ?>">
                    
                    <div class="mb-3">
                        <label class="form-label">日付</label>
                        <input type="date" name="date" class="form-control" value="<?= date('Y-m-d') ?>" required>
                    </div>

<div class="mb-3">
    <label class="form-label">科目</label>
    <select name="category_id" class="form-select" required>
        <option value="">選択してください</option>
        <?php 
        // 修正ポイント: debtor_id が '0000' かどうかでまず並べる
        $st_cat = $pdo->prepare("SELECT * FROM categories 
                                 WHERE debtor_id = '0000' OR debtor_id = ? 
                                 ORDER BY 
                                    CASE WHEN debtor_id = '0000' THEN 0 ELSE 1 END ASC, 
                                    sort_order ASC, 
                                    category_id ASC"); 
        $st_cat->execute([$did]); 
        while ($cat = $st_cat->fetch()): ?>
            <option value="<?= $cat['category_id'] ?>">
                [<?= $cat['type'] == 'income' ? '収入' : '支出' ?>] <?= htmlspecialchars($cat['category_name']) ?>
            </option>
        <?php endwhile; ?>
    </select>
</div>

                    <div class="mb-3">
                        <label class="form-label">金額</label>
                        <input type="number" name="amount" id="amountField" class="form-control" placeholder="¥ 0" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">備考</label>
                        <input type="text" name="memo" id="memoField" class="form-control" placeholder="内容メモ">
                    </div>

                    <div class="mb-3">
                        <label class="form-label">画像（領収書など）</label>
                        <input type="file" name="image" id="imageField" class="form-control" accept="image/*">
                    </div>
                </div>
                <div class="modal-footer border-0">
                    <button type="button" class="btn btn-light" data-bs-dismiss="modal">終了する</button>
                    <button type="submit" id="submitBtn" class="btn btn-primary px-5 shadow-sm" style="border-radius: 10px;">登録</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.getElementById('inputForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const btn = document.getElementById('submitBtn');
    const msg = document.getElementById('alertMsg');
    btn.disabled = true;
    btn.innerHTML = '送信中...';

    const formData = new FormData(this);
    fetch('register_transaction.php', { method: 'POST', body: formData })
    .then(res => {
        msg.classList.remove('d-none');
        document.getElementById('amountField').value = '';
        document.getElementById('memoField').value = '';
        document.getElementById('imageField').value = '';
        btn.disabled = false;
        btn.innerHTML = '登録';
        setTimeout(() => msg.classList.add('d-none'), 2500);
    })
    .catch(err => {
        alert('通信エラーが発生しました');
        btn.disabled = false;
        btn.innerHTML = '登録';
    });
});

document.getElementById('inputModal').addEventListener('hidden.bs.modal', function () {
    location.reload();
});
</script>
</body>
</html>