<?php
require_once 'db.php';
check_login();

$id = $_GET['id'] ?? null;
if (!$id) { die("IDが指定されていません。"); }

// データの取得
$st = $pdo->prepare("SELECT * FROM transactions WHERE id = ?");
$st->execute([$id]);
$data = $st->fetch();

if (!$data) { die("データが見つかりません。"); }

// 権限チェック
if ($_SESSION['role'] !== 'admin' && $data['debtor_id'] !== $_SESSION['debtor_id']) {
    die("閲覧権限がありません。");
}

// 修正後・戻るボタン用のベースURLを作成
$redirect_param = "mode=detail&debtor_id=" . $data['debtor_id'];

// カテゴリ一覧の取得
$st_cat = $pdo->prepare("SELECT * FROM categories WHERE debtor_id = '0000' OR debtor_id = ? ORDER BY type DESC, category_id ASC");
$st_cat->execute([$data['debtor_id']]);
$categories = $st_cat->fetchAll();

// 更新処理
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $amount = $_POST['amount'];
    $category_id = $_POST['category_id'];
    $date = $_POST['date'];
    $memo = $_POST['memo'];
    $image_path = $data['image_path']; // 現在のパスを保持

    // --- 1. 画像削除のチェックがある場合 ---
    if (isset($_POST['delete_image']) && $_POST['delete_image'] === '1') {
        if ($image_path && file_exists($image_path)) {
            @unlink($image_path); // サーバーからファイルを物理削除
        }
        $image_path = null; // DB登録用変数を空にする
    }

    // --- 2. 新しい画像がアップロードされた場合 ---
    if (!empty($_FILES['image']['name'])) {
        // もし古い画像があれば先に消す（上書きのため）
        if ($image_path && file_exists($image_path)) {
            @unlink($image_path);
        }
        
        $upload_dir = 'uploads/';
        $fname = time() . '_' . $_FILES['image']['name'];
        if (move_uploaded_file($_FILES['image']['tmp_name'], $upload_dir . $fname)) {
            $image_path = $upload_dir . $fname;
        }
    }

    $up = $pdo->prepare("UPDATE transactions SET amount=?, category_id=?, date=?, memo=?, image_path=? WHERE id=?");
    $up->execute([$amount, $category_id, $date, $memo, $image_path, $id]);
    
    // 更新後、日付に基づいた月を指定して戻る
    $target_month = date('Y-m', strtotime($date));
    header("Location: view_report.php?{$redirect_param}&month=" . $target_month);
    exit;
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>明細の修正</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        body { background-color: #f0f2f5; font-family: "Helvetica Neue", Arial, sans-serif; }
        .edit-container { max-width: 500px; margin: 30px auto; }
        .card { border: none; border-radius: 12px; }
        .current-image-area { background: #f8f9fa; padding: 10px; border-radius: 8px; border: 1px dashed #ddd; }
    </style>
</head>
<body>
<div class="container edit-container">
    <div class="card shadow-sm">
        <div class="card-body p-4">
            <h4 class="mb-4 fw-bold"><i class="bi bi-pencil-square me-2 text-primary"></i>明細の修正</h4>
            
            <form method="POST" enctype="multipart/form-data">
                <div class="mb-3">
                    <label class="form-label fw-bold small">日付</label>
                    <input type="date" name="date" class="form-control" value="<?= htmlspecialchars($data['date']) ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold small">金額</label>
                    <div class="input-group">
                        <span class="input-group-text">¥</span>
                        <input type="number" name="amount" class="form-control" value="<?= htmlspecialchars($data['amount']) ?>" required>
                    </div>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold small">項目</label>
                    <select name="category_id" class="form-select">
                        <?php foreach($categories as $c): ?>
                            <option value="<?= $c['category_id'] ?>" <?= $c['category_id']==$data['category_id']?'selected':'' ?>>
                                [<?= $c['type']=='income'?'収入':'支出' ?>] <?= htmlspecialchars($c['category_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold small">備考</label>
                    <input type="text" name="memo" class="form-control" value="<?= htmlspecialchars($data['memo']) ?>" placeholder="メモを入力（任意）">
                </div>
                
                <div class="mb-4">
                    <label class="form-label fw-bold small">レシート画像</label>
                    
                    <?php if($data['image_path']): ?>
                        <div class="current-image-area mb-3">
                            <p class="small text-muted mb-2">現在の画像:</p>
                            <div class="d-flex align-items-center gap-3">
                                <img src="<?= htmlspecialchars($data['image_path']) ?>" style="max-width: 120px;" class="img-thumbnail rounded">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="delete_image" value="1" id="deleteImage">
                                    <label class="form-check-label small text-danger fw-bold" for="deleteImage">
                                        この画像を削除する
                                    </label>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <input type="file" name="image" class="form-control" accept="image/*">
                    <div class="form-text small">
                        <?php if($data['image_path']): ?>
                            別の画像を選ぶと、現在の画像は上書きされます。
                        <?php else: ?>
                            画像を追加する場合は、ファイルを選択してください。
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="d-grid gap-2">
                    <button type="submit" class="btn btn-primary fw-bold py-2">更新する</button>
                    <a href="view_report.php?<?= $redirect_param ?>&month=<?= date('Y-m', strtotime($data['date'])) ?>" class="btn btn-outline-secondary py-2">戻る</a>
                </div>
            </form>
        </div>
    </div>
</div>
</body>
</html>