<?php
require_once 'db.php';
check_login();

// 管理者チェック
if ($_SESSION['role'] !== 'admin') {
    header('Location: index.php');
    exit;
}

$did = $_GET['did'] ?? '';
$msg = "";
$msg_type = "success";

// --- 更新処理 ---
if (isset($_POST['save_submit'])) {
    $name = $_POST['name'];
    $pay_day = (int)$_POST['pay_day'];
    $initial_balance = (int)$_POST['initial_balance'];
    
    try {
        $pdo->beginTransaction();

        // 1. 債務者基本情報（debtorsテーブル）の更新
        $st = $pdo->prepare("UPDATE debtors SET name = ?, pay_day = ?, initial_balance = ? WHERE debtor_id = ?");
        $st->execute([$name, $pay_day, $initial_balance, $did]);

        // 2. ユーザー名（usersテーブル）の連動更新
        // 本人（末尾に1）
        $st_u1 = $pdo->prepare("UPDATE users SET user_name = ? WHERE user_code = ?");
        $st_u1->execute([$name . "（本人）", $did . '1']);

        // 配偶者（末尾に2）
        $st_u2 = $pdo->prepare("UPDATE users SET user_name = ? WHERE user_code = ?");
        $st_u2->execute([$name . "（配偶者）", $did . '2']);

        $pdo->commit();
        $msg = "設定を更新しました。本人・配偶者の表示名も更新されました。";
    } catch (Exception $e) {
        if ($pdo->inTransaction()) $pdo->rollBack();
        $msg = "エラー: " . $e->getMessage();
        $msg_type = "danger";
    }
}

// 表示用データの取得
$st = $pdo->prepare("SELECT * FROM debtors WHERE debtor_id = ?");
$st->execute([$did]);
$debtor = $st->fetch();

if (!$debtor) {
    die("債務者が見つかりません。ID: " . htmlspecialchars($did));
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <title>設定編集</title>
    <style>
        .main-card { border-radius: 12px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .section-label { font-size: 0.85rem; font-weight: bold; color: #666; margin-bottom: 5px; display: block; }
    </style>
</head>
<body class="bg-light">
<div class="container mt-5" style="max-width: 500px;">
    <div class="card main-card border-0">
        <div class="card-header bg-dark text-white py-3">
            <h6 class="mb-0">設定の編集: <?= htmlspecialchars($debtor['name']) ?> 様</h6>
        </div>
        <div class="card-body p-4">
            
            <?php if($msg): ?>
                <div class="alert alert-<?= $msg_type ?> alert-dismissible fade show" role="alert">
                    <?= $msg ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="mb-3">
                    <label class="section-label">世帯名（表示名）</label>
                    <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($debtor['name']) ?>" required>
                    <small class="text-muted">変更すると各ユーザー名も「○○（本人）」形式に更新されます。</small>
                </div>

                <div class="mb-3">
                    <label class="section-label">標準起算日（給料日）</label>
                    <select name="pay_day" class="form-select">
                        <?php for($i=1; $i<=28; $i++): ?>
                            <option value="<?= $i ?>" <?= ($debtor['pay_day'] == $i) ? 'selected' : '' ?>><?= $i ?>日</option>
                        <?php endfor; ?>
                    </select>
                </div>

                <div class="mb-4 bg-warning bg-opacity-10 p-3 border border-warning rounded">
                    <label class="section-label text-danger">初回繰越金（開始時の残高）</label>
                    <div class="input-group">
                        <span class="input-group-text">¥</span>
                        <input type="number" name="initial_balance" class="form-control fw-bold text-end" value="<?= (int)$debtor['initial_balance'] ?>" required>
                    </div>
                </div>

                <hr>

                <div class="d-grid gap-2">
                    <button type="submit" name="save_submit" class="btn btn-primary btn-lg fw-bold">
                        設定を保存する
                    </button>
                    <a href="index.php" class="btn btn-outline-secondary">管理画面に戻る</a>
                </div>
            </form>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>