<?php
require_once 'db.php';
check_login();

// IDがない場合は戻す
if (!isset($_GET['id'])) {
    header('Location: index.php');
    exit;
}

$id = (int)$_GET['id'];

// 1. まず、削除対象の取引が「どの世帯(debtor_id)のものか」を確認
//    同時に、権限のない他人のデータを消さないようチェックします
$st = $pdo->prepare("SELECT debtor_id FROM transactions WHERE id = ?");
$st->execute([$id]);
$trans = $st->fetch();

if (!$trans) {
    exit('データが見つかりません');
}

$did = $trans['debtor_id'];

// 2. 権限チェック
// 管理者（admin）か、その世帯の担当者（user）以外は削除不可
if ($_SESSION['role'] !== 'admin' && $_SESSION['debtor_id'] !== $did) {
    exit('削除権限がありません');
}

// 3. 削除実行
$st = $pdo->prepare("DELETE FROM transactions WHERE id = ?");
$st->execute([$id]);

// 4. 元の画面にJavaScriptで戻す
// referrerがあればそこへ、なければレポート画面(did付)へ
$fallback_url = "view_report.php?did=" . $did;

echo "<script>
    alert('削除が完了しました');
    var backUrl = document.referrer;
    if (!backUrl || backUrl.indexOf('delete_transaction.php') !== -1) {
        location.href = '$fallback_url';
    } else {
        location.href = backUrl;
    }
</script>";
exit;