<?php
require_once 'db.php';
// check_login() が db.php にある場合はそれを使うのがスマートです
check_login(); 

// 管理者チェック
if ($_SESSION['role'] !== 'admin') {
    exit('権限がありません');
}

// パラメータ名を debtor_id に修正
$debtor_id = $_GET['debtor_id'] ?? '';

if (empty($debtor_id)) {
    exit('債務者IDが指定されていません');
}

try {
    // トランザクション開始
    $pdo->beginTransaction();

    // 1. 取引履歴の削除
    $st1 = $pdo->prepare("DELETE FROM transactions WHERE debtor_id = ?");
    $st1->execute([$debtor_id]);

    // 2. 個別科目の削除
    $st2 = $pdo->prepare("DELETE FROM categories WHERE debtor_id = ?");
    $st2->execute([$debtor_id]);

    // 3. ユーザー（ログインアカウント）の削除
    // user_code が debtor_id と同一、または debtor_id カラムを持っている前提
    $st3 = $pdo->prepare("DELETE FROM users WHERE debtor_id = ?");
    $st3->execute([$debtor_id]);

    // 4. 債務者本体の削除
    $st4 = $pdo->prepare("DELETE FROM debtors WHERE debtor_id = ?");
    $st4->execute([$debtor_id]);

    // すべて成功したら確定
    $pdo->commit();

    header('Location: index.php?msg=deleted');
    exit;

} catch (Exception $e) {
    // エラー時はロールバック
    if ($pdo->inTransaction()) {
        $pdo->rollBack();
    }
    exit('削除に失敗しました: ' . $e->getMessage());
}