<?php
require_once 'db.php';
check_login();

if ($_SESSION['role'] !== 'admin') {
    exit('アクセス権限がありません。');
}

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['backup_zip'])) {
    $zip_file = $_FILES['backup_zip']['tmp_name'];

    if (!is_uploaded_file($zip_file)) {
        $error = 'ファイルがアップロードされていません。';
    } else {
        $zip = new ZipArchive();
        if ($zip->open($zip_file) === TRUE) {
            
            $sql_file = '';
            for ($i = 0; $i < $zip->numFiles; $i++) {
                $filename = $zip->getNameIndex($i);
                if (strtolower(pathinfo($filename, PATHINFO_EXTENSION)) === 'sql') {
                    $sql_file = $filename;
                    break;
                }
            }

            if ($sql_file) {
                $sql_data = $zip->getFromName($sql_file);
                $lines = explode("\n", $sql_data);
                unset($sql_data);

                try {
                    $pdo->exec("SET FOREIGN_KEY_CHECKS = 0");

                    $templine = '';
                    foreach ($lines as $line) {
                        if (trim($line) == '' || strpos(trim($line), '--') === 0 || strpos(trim($line), '/*') === 0) {
                            continue;
                        }
                        $templine .= $line;
                        if (substr(trim($line), -1, 1) == ';') {
                            $pdo->exec($templine);
                            $templine = '';
                        }
                    }

                    $pdo->exec("SET FOREIGN_KEY_CHECKS = 1");

                    // 画像の復元
                    $upload_dir = 'uploads/';
                    if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

                    $restore_count = 0;
                    for ($i = 0; $i < $zip->numFiles; $i++) {
                        $filename = $zip->getNameIndex($i);
                        if (strpos($filename, 'uploads/') === 0 && substr($filename, -1) !== '/') {
                            $zip->extractTo('.', $filename);
                            $restore_count++;
                        }
                    }
                    $zip->close();
                    
                    // index.phpに戻る
                    header('Location: index.php?msg=restored');
                    exit;

                } catch (Exception $e) {
                    $error = "復元中にエラーが発生しました。<br><strong>詳細:</strong> " . htmlspecialchars($e->getMessage());
                }
            } else {
                $error = "ZIP内にバックアップSQLが見つかりません。";
            }
            $zip->close();
        } else {
            $error = "ZIPファイルを開けませんでした。";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>データリストア（復元）</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <style>
        .restore-header { background: linear-gradient(135deg, #dc3545 0%, #a71d2a 100%); }
        .info-box { border-left: 5px solid #0dcaf0; background-color: #f8f9fa; }
        #loading-overlay {
            display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(255, 255, 255, 0.9); z-index: 9999;
            flex-direction: column; align-items: center; justify-content: center;
        }
    </style>
</head>
<body class="bg-light">

<div id="loading-overlay">
    <div class="spinner-border text-danger mb-3" style="width: 3rem; height: 3rem;" role="status"></div>
    <h5 class="fw-bold text-danger">データを復元しています...</h5>
    <p class="text-muted small">完了すると自動的に管理画面に戻ります。</p>
</div>

<div class="container mt-5" style="max-width: 750px;">
    <nav aria-label="breadcrumb" class="mb-3">
        <a href="index.php" class="text-decoration-none small text-secondary">← 管理者パネルへ戻る</a>
    </nav>

    <div class="card shadow border-0 overflow-hidden">
        <div class="card-header restore-header text-white py-3">
            <h5 class="mb-0 fw-bold"><i class="bi bi-arrow-counterclockwise me-2"></i>データリストア（復元）</h5>
        </div>
        <div class="card-body p-4">
            <?php if ($error): ?>
                <div class="alert alert-danger shadow-sm mb-4"><?= $error ?></div>
            <?php endif; ?>

            <h6 class="fw-bold mb-3"><i class="bi bi-info-circle me-1"></i> リストアの仕組みと安心ガイド</h6>
            <div class="info-box p-3 mb-4 rounded shadow-sm">
                <div class="mb-3 border-bottom pb-2">
                    <span class="badge bg-primary mb-1">個別バックアップ(世帯別)の場合</span>
                    <p class="small mb-0 text-dark">
                        選択した世帯のデータのみを最新の状態へ上書きします。<strong>他の世帯のデータは一切変更されません。</strong>
                    </p>
                </div>
                <div>
                    <span class="badge bg-dark mb-1">システム全出力(フル)の場合</span>
                    <p class="small mb-0 text-dark">
                        システム全体の全世帯データを、バックアップ時点の状態へ一括で戻します。
                    </p>
                </div>
            </div>

            <form method="POST" enctype="multipart/form-data" id="restoreForm">
                <div class="mb-4 bg-white p-3 border rounded">
                    <label class="form-label fw-bold">バックアップZIPファイルを選択</label>
                    <input type="file" name="backup_zip" class="form-control form-control-lg" accept=".zip" required>
                </div>
                
                <div class="d-grid">
                    <button type="submit" class="btn btn-danger btn-lg fw-bold shadow">
                        リストアを開始する
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('restoreForm').addEventListener('submit', function(e) {
    if (!confirm('リストアを実行します。対象データは上書きされますがよろしいですか？')) {
        e.preventDefault();
        return;
    }
    document.getElementById('loading-overlay').style.display = 'flex';
});
</script>
</body>
</html>