<?php
require_once 'db.php';
check_login();

// 管理者以外は実行不可
if ($_SESSION['role'] !== 'admin') {
    exit('アクセス権限がありません。');
}

// 世帯IDの取得
$debtor_id = isset($_GET['debtor_id']) ? $_GET['debtor_id'] : exit('世帯IDが指定されていません。');

try {
    // 世帯情報の取得（ファイル名に使用）
    $st = $pdo->prepare("SELECT name FROM debtors WHERE debtor_id = ?");
    $st->execute([$debtor_id]);
    $debtor = $st->fetch();
    if (!$debtor) exit('対象の世帯が見つかりません。');
    $debtor_name = $debtor['name'];

    $zipname = 'backup_' . $debtor_name . '_' . date('Ymd_His') . '.zip';
    $tmp_zip = tempnam(sys_get_temp_dir(), 'zip');
    $zip = new ZipArchive();

    if ($zip->open($tmp_zip, ZipArchive::CREATE) !== TRUE) {
        exit("ZIPファイルの作成に失敗しました。");
    }

    // --- 1. 世帯限定のSQL作成 ---
    $sql_content = "-- 世帯別バックアップ: $debtor_name (ID: $debtor_id)\n";
    $sql_content .= "-- 生成日時: " . date("Y-m-d H:i:s") . "\n\n";
    $sql_content .= "SET FOREIGN_KEY_CHECKS=0;\n\n";

    // 【重要】復元時に他の世帯を傷つけず、この世帯だけを上書きするための削除命令
    $sql_content .= "-- 復元用クリーンアップ（この世帯の既存データのみ削除）\n";
    $sql_content .= "DELETE FROM transactions WHERE debtor_id = '$debtor_id';\n";
    $sql_content .= "DELETE FROM categories WHERE debtor_id = '$debtor_id';\n";
    $sql_content .= "DELETE FROM users WHERE debtor_id = '$debtor_id';\n";
    $sql_content .= "DELETE FROM debtors WHERE debtor_id = '$debtor_id';\n\n";

    // 対象テーブルと抽出条件の定義
    // categoriesは「その世帯専用」のみバックアップ（共通科目は復元先にあるはずなので除外）
    $tables = [
        'debtors'      => "WHERE debtor_id = '$debtor_id'",
        'users'        => "WHERE debtor_id = '$debtor_id'",
        'categories'   => "WHERE debtor_id = '$debtor_id'", 
        'transactions' => "WHERE debtor_id = '$debtor_id'"
    ];

    foreach ($tables as $table => $condition) {
        $sql_content .= "-- Table: $table\n";
        
        // データ抽出
        $res = $pdo->query("SELECT * FROM $table $condition");
        while ($r = $res->fetch(PDO::FETCH_NUM)) {
            $sql_content .= "INSERT INTO $table VALUES(" . implode(',', array_map(function($v) use ($pdo) {
                return is_null($v) ? 'NULL' : $pdo->quote($v);
            }, $r)) . ");\n";
        }
        $sql_content .= "\n";
    }
    
    $sql_content .= "SET FOREIGN_KEY_CHECKS=1;\n";
    $zip->addFromString('database_backup_single.sql', $sql_content);

    // --- 2. 関連画像のみを特定してZIPに追加 ---
    $upload_dir = 'uploads';
    if (is_dir($upload_dir)) {
        $st_img = $pdo->prepare("SELECT image_path FROM transactions WHERE debtor_id = ? AND image_path IS NOT NULL AND image_path <> ''");
        $st_img->execute([$debtor_id]);
        $images = $st_img->fetchAll(PDO::FETCH_COLUMN);

        foreach ($images as $img) {
            $filePath = realpath($img);
            if (!$filePath) {
                $filePath = realpath($upload_dir . '/' . basename($img));
            }

            if ($filePath && file_exists($filePath) && is_file($filePath)) {
                $zip->addFile($filePath, 'uploads/' . basename($filePath));
            }
        }
    }

    $zip->close();

    // --- 3. ダウンロード配信 ---
    header('Content-Type: application/zip');
    header('Content-Disposition: attachment; filename="' . $zipname . '"');
    header('Content-Length: ' . filesize($tmp_zip));
    ob_clean();
    flush();
    readfile($tmp_zip);
    unlink($tmp_zip);
    exit;

} catch (Exception $e) {
    echo "バックアップ中にエラーが発生しました: " . $e->getMessage();
}