<?php
require_once 'db.php';
check_login();

// 管理者以外はアクセス禁止
if ($_SESSION['role'] !== 'admin') {
    exit('アクセス権限がありません。');
}

$debtor_id = $_GET['debtor_id'] ?? null;
if (!$debtor_id) {
    exit('世帯IDが指定されていません。');
}

// 世帯情報の確認（表示用）
$st = $pdo->prepare("SELECT name FROM debtors WHERE debtor_id = ?");
$st->execute([$debtor_id]);
$debtor = $st->fetch();

if (!$debtor) {
    exit('世帯が見つかりません。');
}

$message = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_pass = $_POST['new_password'];
    $confirm_pass = $_POST['confirm_password'];

    if (empty($new_pass)) {
        $error = '新しいパスワードを入力してください。';
    } elseif ($new_pass !== $confirm_pass) {
        $error = '確認用パスワードが一致しません。';
    } else {
        try {
            // パスワードをハッシュ化
            $hashed_password = password_hash($new_pass, PASSWORD_DEFAULT);

            // この世帯(debtor_id)に紐づく全てのユーザーコードのパスワードを更新
            $up = $pdo->prepare("UPDATE users SET password = ? WHERE debtor_id = ?");
            $up->execute([$hashed_password, $debtor_id]);

            $count = $up->rowCount();
            $message = "パスワードを更新しました。（更新対象：{$count}アカウント）";
        } catch (Exception $e) {
            $error = 'エラーが発生しました：' . $e->getMessage();
        }
    }
}
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>パスワード変更 | 管理者用</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>
<body class="bg-light">

<div class="container mt-5" style="max-width: 500px;">
    <nav class="mb-3">
        <a href="index.php" class="text-decoration-none small text-secondary">← 管理者パネルへ戻る</a>
    </nav>

    <div class="card shadow-sm border-0">
        <div class="card-header bg-info text-white py-3">
            <h5 class="mb-0 fw-bold"><i class="bi bi-key-fill me-2"></i>パスワード一括変更</h5>
        </div>
        <div class="card-body p-4">
            <div class="mb-4">
                <label class="form-label text-muted small mb-1">対象世帯</label>
                <div class="h5 fw-bold"><?= htmlspecialchars($debtor['name']) ?> 様</div>
                <p class="small text-muted">※この世帯に登録されている全てのユーザーコードのパスワードが変更されます。</p>
            </div>

            <?php if ($message): ?>
                <div class="alert alert-success small"><?= $message ?></div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="alert alert-danger small"><?= $error ?></div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label fw-bold small">新しいパスワード</label>
                    <input type="password" name="new_password" class="form-control" placeholder="8文字以上推奨" required>
                </div>
                <div class="mb-4">
                    <label class="form-label fw-bold small">新しいパスワード（確認）</label>
                    <input type="password" name="confirm_password" class="form-control" placeholder="もう一度入力してください" required>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-info text-white fw-bold py-2 shadow-sm">
                        パスワードを更新する
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

</body>
</html>