<?php
require_once 'db.php';
check_login();

// 管理者権限チェック
if ($_SESSION['role'] !== 'admin') {
    exit('アクセス権限がありません。');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $current_password = $_POST['current_password'] ?? '';
    $new_password     = $_POST['new_password'] ?? '';
    $confirm_password = $_POST['confirm_password'] ?? '';

    // 入力チェック
    if (empty($current_password) || empty($new_password)) {
        $error = 'すべての項目を入力してください。';
    } elseif ($new_password !== $confirm_password) {
        $error = '新しいパスワードが一致しません。';
    } else {
        // 現在のパスワード確認 (user_code = admin)
        $st = $pdo->prepare("SELECT password FROM users WHERE user_code = 'admin' LIMIT 1");
        $st->execute();
        $user = $st->fetch();

        if ($user && password_verify($current_password, $user['password'])) {
            // 新しいパスワードをハッシュ化
            $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
            
            // アップデート
            $up = $pdo->prepare("UPDATE users SET password = ? WHERE user_code = 'admin'");
            if ($up->execute([$hashed_password])) {
                $success = 'パスワードを更新しました。';
            } else {
                $error = 'データベースの更新に失敗しました。';
            }
        } else {
            $error = '現在のパスワードが正しくありません。';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="UTF-8">
    <title>管理者パスワード変更</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background-color: #f4f7f6; padding-top: 50px; }
        .form-container { max-width: 400px; margin: 0 auto; background: white; padding: 30px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        .btn-update { background-color: #2c3e50; color: white; width: 100%; }
        .btn-update:hover { background-color: #1a252f; color: white; }
    </style>
</head>
<body>

<div class="container">
    <div class="form-container">
        <h4 class="text-center mb-4">管理者パスワード変更</h4>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
            <div class="text-center mt-3">
                <a href="index.php" class="btn btn-outline-secondary w-100">ダッシュボードへ戻る</a>
            </div>
        <?php else: ?>

            <form method="POST">
                <div class="mb-3">
                    <label class="form-label">現在のパスワード</label>
                    <input type="password" name="current_password" class="form-control" required>
                </div>
                <hr>
                <div class="mb-3">
                    <label class="form-label">新しいパスワード</label>
                    <input type="password" name="new_password" class="form-control" required>
                </div>
                <div class="mb-4">
                    <label class="form-label">新しいパスワード（確認用）</label>
                    <input type="password" name="confirm_password" class="form-control" required>
                </div>

                <button type="submit" class="btn btn-update mb-3">パスワードを更新する</button>
                <a href="index.php" class="btn btn-light w-100 border">キャンセル</a>
            </form>

        <?php endif; ?>
    </div>
</div>

</body>
</html>