<?php
/*
Plugin Name: Classic Guestbook
Description: 昔懐かしいゲストブックです。ショートコード[classic_guestbook]で設置できます。
Version: 1.0
Author: HATABOW
*/

if (!defined('ABSPATH')) exit;

// 1. データベーステーブルの作成（変更なし）
register_activation_hook(__FILE__, 'cgb_create_table');
function cgb_create_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'classic_guestbook';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        dt datetime DEFAULT CURRENT_TIMESTAMP NOT NULL,
        nk varchar(100) NOT NULL,
        rn varchar(100) DEFAULT '',
        msg text NOT NULL,
        pw varchar(100) NOT NULL,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}

// 2. メインロジック（ショートコード）
add_shortcode('classic_guestbook', 'cgb_render_guestbook');
function cgb_render_guestbook() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'classic_guestbook';
    $output = '';
    $error_msg = '';
    $keep_edit_form = false; // パスワード失敗時に編集画面を維持するためのフラグ

    // --- データ処理 ---
    $mode = $_POST['mode'] ?? '';
    $target_id = isset($_POST['target_id']) ? intval($_POST['target_id']) : 0;
    $input_pw = $_POST['password'] ?? '';

    // A. 新規投稿
    if ($mode === 'post' && !empty($_POST['nickname']) && !empty($_POST['message'])) {
        $wpdb->insert($table_name, [
            'dt'  => current_time('mysql'),
            'nk'  => sanitize_text_field($_POST['nickname']),
            'rn'  => sanitize_text_field($_POST['realname']),
            'msg' => nl2br(sanitize_textarea_field($_POST['message'])),
            'pw'  => $_POST['password']
        ]);
    }
    // B. 編集実行
    elseif ($mode === 'update' && $target_id) {
        $row = $wpdb->get_row($wpdb->prepare("SELECT pw FROM $table_name WHERE id = %d", $target_id));
        if ($row && $row->pw === $input_pw) {
            $wpdb->update($table_name, [
                'nk'  => sanitize_text_field($_POST['nickname']),
                'rn'  => sanitize_text_field($_POST['realname']),
                'msg' => nl2br(sanitize_textarea_field($_POST['message']))
            ], ['id' => $target_id]);
        } else {
            $error_msg = "パスワードが正しくありません。内容を保持しました。";
            $keep_edit_form = true; // 編集画面を再度表示する
        }
    }
    // C. 削除実行
    elseif ($mode === 'delete_exec' && $target_id) {
        $row = $wpdb->get_row($wpdb->prepare("SELECT pw FROM $table_name WHERE id = %d", $target_id));
        if ($row && $row->pw === $input_pw) {
            $wpdb->delete($table_name, ['id' => $target_id]);
        } else {
            $error_msg = "パスワードが不一致です。";
        }
    }

    // --- CSS（前回と同じ） ---
    $output .= '
    <style>
        .cgb-body { background-color: #000; color: #D4AF37; font-family: sans-serif; padding: 15px; font-weight: 900; }
        .cgb-header-container { border-bottom: 3px solid #D4AF37; padding-bottom: 15px; margin-bottom: 25px; }
        .cgb-error-banner { background: #600; color: #fff; padding: 15px; border: 2px solid #f00; margin-bottom: 20px; border-radius: 5px; }
        .cgb-form-area { background: #111; padding: 20px; border: 2px solid #D4AF37; margin-bottom: 30px; border-radius: 10px; }
        .cgb-form-area input[type="text"], .cgb-form-area input[type="password"], .cgb-form-area textarea { 
            background: #222; color: #fff; border: 1px solid #D4AF37; padding: 12px; width: 100%; box-sizing: border-box; font-weight: 700; margin-bottom: 10px; font-size: 16px; 
        }
        .cgb-btn, .cgb-form-area input[type="submit"] { 
            background-color: #000 !important; color: #D4AF37 !important; border: 1px solid #D4AF37 !important; 
            font-weight: 900; cursor: pointer; padding: 12px 40px; display: inline-block; text-decoration: none;
        }
        .cgb-btn-mini { font-size: 0.75rem !important; padding: 4px 0 !important; width: 48px !important; height: 26px !important; line-height: 1 !important; margin: 2px auto; display: block; background: #000; color: #D4AF37; border: 1px solid #D4AF37; }
        .cgb-table { border-collapse: collapse; width: 100%; border: 3px solid #D4AF37; color: #D4AF37; }
        .cgb-table th, .cgb-table td { border: 1px solid #D4AF37; padding: 6px 4px; text-align: center; }
        .cgb-table th { background-color: #111; font-size: 0.8rem; }
        .col-dt { color:#B8860B; font-size:0.75rem; white-space: nowrap; }
        .col-msg { text-align: left !important; word-wrap: break-word; }
    </style>';

    $output .= '<div class="cgb-body">';
    if ($error_msg) $output .= '<div class="cgb-error-banner">⚠️ ' . $error_msg . '</div>';

    // --- フォーム表示セクション ---
    
    // 編集画面を表示すべき条件：
    // 1. 最初の一覧から「編集」ボタンが押されたとき (edit_idがある)
    // 2. 更新に失敗して差し戻されたとき (keep_edit_formがtrue)
    if (isset($_POST['edit_id']) || $keep_edit_form) {
        $display_id = $keep_edit_form ? $target_id : intval($_POST['edit_id']);
        
        if ($keep_edit_form) {
            // パスワード失敗時は、DBの値ではなく「いま送信した内容」を表示
            $v_nk = sanitize_text_field($_POST['nickname']);
            $v_rn = sanitize_text_field($_POST['realname']);
            $v_msg = sanitize_textarea_field($_POST['message']); // nl2br前
        } else {
            // 初めて編集画面を開くときはDBから取得
            $target = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE id = %d", $display_id));
            if ($target) {
                $v_nk = $target->nk;
                $v_rn = $target->rn;
                $v_msg = str_replace(['<br />', '<br>'], "", $target->msg);
            }
        }

        if (isset($v_nk)) {
            $output .= '<div class="cgb-form-area"><h2>編集</h2><form method="POST">
                <input type="hidden" name="mode" value="update"><input type="hidden" name="target_id" value="'.$display_id.'">
                ニックネーム: <input type="text" name="nickname" value="'.esc_attr($v_nk).'" required>
                お名前: <input type="text" name="realname" value="'.esc_attr($v_rn).'">
                メッセージ: <textarea name="message" rows="4" required>'.esc_textarea($v_msg).'</textarea>
                パスワード: <input type="password" name="password" required>
                <input type="submit" value="修正を保存"> <a href="'.get_permalink().'" class="cgb-btn">キャンセル</a>
            </form></div>';
        }
    } 
    // 削除確認画面
    elseif (isset($_POST['delete_id'])) {
        $delete_id = intval($_POST['delete_id']);
        $output .= '<div class="cgb-form-area"><h2>削除確認</h2><form method="POST">
            <input type="hidden" name="mode" value="delete_exec"><input type="hidden" name="target_id" value="'.$delete_id.'">
            パスワード: <input type="password" name="password" required>
            <input type="submit" value="削除" style="background:#a00 !important; color:#fff !important;"> 
            <a href="'.get_permalink().'" class="cgb-btn">キャンセル</a>
        </form></div>';
    } 
    // 通常の新規投稿フォーム
    else {
        $output .= '<div class="cgb-form-area"><form method="POST">
            <input type="hidden" name="mode" value="post">
            ニックネーム: <input type="text" name="nickname" required>
            お名前: <input type="text" name="realname">
            メッセージ: <textarea name="message" rows="3" required></textarea>
            パスワード: <input type="password" name="password" required>
            <input type="submit" value="メッセージを刻む">
        </form></div>';
    }

    // --- 一覧表示（前回と同じ） ---
    $output .= '<table class="cgb-table"><thead><tr>
        <th>ニックネーム</th><th>名前</th><th>メッセージ</th><th>投稿日時</th><th>操作</th>
    </tr></thead><tbody>';

    $posts = $wpdb->get_results("SELECT * FROM $table_name ORDER BY dt DESC");
    foreach ($posts as $row) {
        $output .= "<tr>
            <td>" . esc_html($row->nk) . "</td>
            <td>" . esc_html($row->rn) . "</td>
            <td class='col-msg'>" . $row->msg . "</td>
            <td class='col-dt'>" . esc_html($row->dt) . "</td>
            <td>
                <form method='POST' style='display:inline;'><input type='hidden' name='edit_id' value='{$row->id}'><input type='submit' class='cgb-btn-mini' value='編集'></form>
                <form method='POST' style='display:inline;'><input type='hidden' name='delete_id' value='{$row->id}'><input type='submit' class='cgb-btn-mini' value='削除'></form>
            </td>
        </tr>";
    }
    $output .= '</tbody></table></div>';

    return $output;
}
