<?php
/**
 * Plugin Name: 昔のうぇぶ会議室
 * Plugin URI:  https://hatabow.net/?page_id=160
 * Description: 昔あったCGIのうぇぶ会議室（3フレーム形式）の今風版です。3ペイン・スレッド形式です。
 * Version: 1.0
 * Author: HATABOW
 * Author URI:  https://hatabow.net/
 * Text Domain: modern-kaigishitsu
*/

if ( ! defined( 'ABSPATH' ) ) exit;

// --- 1. データベース作成・更新 ---
function m_kaigishitsu_install() {
    global $wpdb;
    $table_posts = $wpdb->prefix . 'm_kaigishitsu_posts';
    $table_forums = $wpdb->prefix . 'm_kaigishitsu_forums';
    $charset_collate = $wpdb->get_charset_collate();

    $sql1 = "CREATE TABLE $table_forums (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        name text NOT NULL,
        description text,
        sort_order int(11) DEFAULT 0,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    $sql2 = "CREATE TABLE $table_posts (
        id bigint(20) NOT NULL AUTO_INCREMENT,
        forum_id bigint(20) NOT NULL,
        parent_id bigint(20) DEFAULT 0,
        author text NOT NULL,
        title text NOT NULL,
        body text NOT NULL,
        password text NOT NULL,
        created_at datetime DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    dbDelta( $sql1 );
    dbDelta( $sql2 );
}
register_activation_hook( __FILE__, 'm_kaigishitsu_install' );

// --- 2. 管理画面：フォーラム管理 ---
add_action('admin_menu', 'm_kaigishitsu_admin_menu');
function m_kaigishitsu_admin_menu() {
    add_menu_page('うぇぶ会議室管理', 'うぇぶ会議室', 'manage_options', 'm-kaigishitsu-admin', 'm_kaigishitsu_admin_page', 'dashicons-groups');
}

function m_kaigishitsu_admin_page() {
    global $wpdb;
    $table_forums = $wpdb->prefix . 'm_kaigishitsu_forums';

    if (isset($_POST['save_welcome_msg'])) {
        update_option('m_kaigishitsu_label_top', sanitize_text_field($_POST['label_top']));
        update_option('m_kaigishitsu_msg_top', wp_kses_post($_POST['msg_top']));
        update_option('m_kaigishitsu_label_bottom', sanitize_text_field($_POST['label_bottom']));
        update_option('m_kaigishitsu_msg_bottom', wp_kses_post($_POST['msg_bottom']));
        echo '<div class="updated"><p>表示設定を保存しました。</p></div>';
    }

    if (isset($_POST['add_forum'])) {
        $wpdb->insert($table_forums, array(
            'name' => sanitize_text_field($_POST['forum_name']),
            'description' => wp_kses_post($_POST['forum_desc']),
            'sort_order' => intval($_POST['sort_order'])
        ));
    }
    if (isset($_POST['update_forum'])) {
        $wpdb->update($table_forums, array(
            'name' => sanitize_text_field($_POST['forum_name']),
            'description' => wp_kses_post($_POST['forum_desc']),
            'sort_order' => intval($_POST['sort_order'])
        ), array('id' => intval($_POST['forum_id'])));
    }
    if (isset($_GET['delete_forum'])) {
        $wpdb->delete($table_forums, array('id' => intval($_GET['delete_forum'])));
    }

    $forums = $wpdb->get_results("SELECT * FROM $table_forums ORDER BY sort_order ASC, id ASC");
    $label_top = get_option('m_kaigishitsu_label_top', 'お知らせ');
    $msg_top = get_option('m_kaigishitsu_msg_top', '会議室を選択してください。');
    $label_bottom = get_option('m_kaigishitsu_label_bottom', '会議室のご案内');
    $msg_bottom = get_option('m_kaigishitsu_msg_bottom', '管理者からの案内が表示されます。');
    ?>
    <div class="wrap">
        <h1>うぇぶ会議室管理</h1>
        <div style="background:#fff; padding:20px; border:1px solid #ccd0d4; margin-bottom:20px;">
            <h2>1. ホーム画面の表示設定</h2>
            <form method="post">
                <div style="display:flex; gap:20px;">
                    <div style="flex:1; background:#f9f9f9; padding:15px;">
                        <label>上段ラベル:</label><br><input type="text" name="label_top" value="<?php echo esc_attr($label_top); ?>" style="width:100%;"><br>
                        <label>上段本文:</label><br><textarea name="msg_top" style="width:100%; height:80px;"><?php echo esc_textarea($msg_top); ?></textarea>
                    </div>
                    <div style="flex:1; background:#f9f9f9; padding:15px;">
                        <label>下段ラベル:</label><br><input type="text" name="label_bottom" value="<?php echo esc_attr($label_bottom); ?>" style="width:100%;"><br>
                        <label>下段本文:</label><br><textarea name="msg_bottom" style="width:100%; height:80px;"><?php echo esc_textarea($msg_bottom); ?></textarea>
                    </div>
                </div>
                <p><input type="submit" name="save_welcome_msg" value="ホーム表示設定を保存" class="button button-primary"></p>
            </form>
        </div>
        <h2>2. 会議室の管理</h2>
        <form method="post" style="margin-bottom:20px; background:#fff; padding:15px; border:1px solid #ccd0d4;">
            <input type="text" name="forum_name" placeholder="会議室名" required style="width:200px;">
            順位: <input type="number" name="sort_order" value="0" style="width:50px;">
            <br><br>
            <label>会議室の説明:</label><br>
            <textarea name="forum_desc" style="width:100%; height:60px;"></textarea>
            <p><input type="submit" name="add_forum" value="追加" class="button button-primary"></p>
        </form>
        <table class="wp-list-table widefat fixed striped">
            <thead><tr><th width="60">順序</th><th width="200">会議室名</th><th>説明</th><th width="160">操作</th></tr></thead>
            <tbody>
            <?php if($forums): foreach($forums as $f): ?>
            <tr>
                <form method="post">
                <td><input type="number" name="sort_order" value="<?php echo $f->sort_order; ?>" style="width:45px;"></td>
                <td><input type="text" name="forum_name" value="<?php echo esc_attr($f->name); ?>" required style="width:95%;"></td>
                <td><textarea name="forum_desc" style="width:95%; height:40px;"><?php echo esc_textarea($f->description); ?></textarea></td>
                <td>
                    <input type="hidden" name="forum_id" value="<?php echo $f->id; ?>">
                    <input type="submit" name="update_forum" value="更新" class="button">
                    <a href="?page=m-kaigishitsu-admin&delete_forum=<?php echo $f->id; ?>" class="button button-link-delete" onclick="return confirm('削除しますか？')">削除</a>
                </td>
                </form>
            </tr>
            <?php endforeach; endif; ?>
            </tbody>
        </table>
    </div>
    <?php
}

// --- 3. 投稿・編集・削除処理 ---
function m_kaigishitsu_handle_actions() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'm_kaigishitsu_posts';
    if ( isset($_POST['m_kaigishitsu_submit']) ) {
        if ( !empty($_POST['m_kaigishitsu_hp']) ) { wp_die('スパムを検出しました。'); exit; }
        $post_id = intval($_POST['edit_post_id']);
        $pass = sanitize_text_field($_POST['password']);
        $fid = intval($_POST['forum_id']);
        $data = array(
            'forum_id' => $fid,
            'parent_id' => intval($_POST['parent_id']),
            'author' => sanitize_text_field($_POST['author']),
            'title' => sanitize_text_field($_POST['title']),
            'body' => sanitize_textarea_field($_POST['body']),
        );
        if ($post_id > 0) {
            $original = $wpdb->get_row($wpdb->prepare("SELECT password FROM $table_name WHERE id = %d", $post_id));
            if (current_user_can('manage_options') || ($original && $original->password === $pass)) $wpdb->update($table_name, $data, array('id' => $post_id));
        } else {
            $data['password'] = $pass; $wpdb->insert($table_name, $data);
        }
        wp_redirect( add_query_arg('fid', $fid) ); exit;
    }
    if ( isset($_POST['m_kaigishitsu_delete']) ) {
        $post_id = intval($_POST['delete_post_id']);
        $pass = sanitize_text_field($_POST['del_password']);
        if (current_user_can('manage_options') || $wpdb->get_var($wpdb->prepare("SELECT 1 FROM $table_name WHERE id = %d AND password = %s", $post_id, $pass))) {
            $wpdb->delete($table_name, array('id' => $post_id));
        }
        wp_redirect( remove_query_arg('m_kaigishitsu_delete') ); exit;
    }
}
add_action( 'template_redirect', 'm_kaigishitsu_handle_actions' );

// --- 4. ツリー表示用関数 ---
if ( ! function_exists( 'm_kaigishitsu_render_tree_html' ) ) {
    function m_kaigishitsu_render_tree_html($nodes, $level = 0) {
        foreach ($nodes as $node) {
            $date_display = date('m/d H:i', strtotime($node->created_at));
            $mark = ($level > 0) ? '└' : '■';
            $mark_color = ($level > 0) ? '#ccc' : '#444';
            echo "<div class='post-row' onclick=\"showPost($node->id, '".esc_js($node->title)."', '".esc_js($node->author)."', '".esc_js($node->created_at)."', '".esc_js($node->body)."')\">";
            echo "<div class='post-title-cell' style='padding-left:".($level*15)."px;'>";
            echo "<span class='post-mark' style='color:$mark_color;'>$mark</span>";
            echo "<span class='post-title-text'>" . esc_html($node->title) . "</span>";
            echo "</div>";
            echo "<div class='post-info-meta'><span>" . esc_html($node->author) . "</span><br><span>" . $date_display . "</span></div></div>";
            if (!empty($node->children)) {
                m_kaigishitsu_render_tree_html($node->children, $level + 1);
            }
        }
    }
}

// --- 5. ツリーデータ構築 ---
function m_kaigishitsu_build_tree_data($elements, $parentId = 0) {
    $branch = array();
    foreach ($elements as $element) {
        if ($element->parent_id == $parentId) {
            $children = m_kaigishitsu_build_tree_data($elements, $element->id);
            if ($children) $element->children = $children;
            $branch[] = $element;
        }
    }
    return $branch;
}

// --- 6. メイン表示 ---
function m_kaigishitsu_shortcode() {
    global $wpdb;
    $is_admin = current_user_can('manage_options');
    $forums = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}m_kaigishitsu_forums ORDER BY sort_order ASC, id ASC");
    $current_fid = isset($_GET['fid']) ? intval($_GET['fid']) : 0;
    
    $current_forum = null;
    if ($current_fid > 0) {
        foreach ($forums as $f) { if ($f->id == $current_fid) { $current_forum = $f; break; } }
    }

    ob_start(); ?>
    <style>
        .m-forum-wrapper { display: flex; height: 700px; border: 1px solid #ddd; font-family: "Hiragino Sans", Meiryo, sans-serif; font-size: 13px; background: #fff; line-height: 1.4; border-radius: 8px; overflow: hidden; }
        .m-forum-sidebar { width: 160px; background: #f4f4f4; border-right: 1px solid #ddd; padding: 5px; overflow-y: auto; }
        .forum-link { display: block; padding: 4px 8px; color: #333; text-decoration: none !important; border-radius: 3px; margin-bottom: 2px; font-size: 12px; }
        .forum-link.active { background: #0073aa; color: #fff !important; font-weight: bold; }
        .m-forum-content { flex: 1; display: flex; flex-direction: column; overflow: hidden; }
        .m-post-list { height: 40%; overflow-y: auto; border-bottom: 1px solid #ddd; }
        .new-post-btn { display: block; padding: 6px 12px; color: #0073aa; text-decoration: none; font-weight: bold; border-bottom: 1px solid #eee; font-size: 12px; background: #fff; position: sticky; top: 0; z-index: 10;}
        .post-row { padding: 4px 12px; cursor: pointer; border-bottom: 1px solid #f0f0f0; display: flex; justify-content: space-between; align-items: flex-start; }
        .post-row:hover { background: #f0f7ff; }
        .post-title-cell { display: flex; align-items: flex-start; flex: 1; min-width: 0; }
        .post-mark { flex-shrink: 0; width: 1.5em; display: inline-block; }
        .post-title-text { flex: 1; word-break: break-all; white-space: normal; }
        .post-info-meta { text-align: right; color: #888; font-size: 10px; flex-shrink: 0; line-height: 1.2; margin-left: 10px; }
        .m-post-detail { height: 60%; overflow-y: auto; padding: 15px 25px; background: #fff; }
        .btn { padding: 3px 10px; border-radius: 4px; font-size: 11px; cursor: pointer; border: 1px solid #ccc; background: #fff; font-weight: bold; }
        .m-post-form { display: none; background: #f9f9f9; padding: 15px; border: 1px solid #ddd; border-radius: 6px; margin-top: 10px; }
        .m-post-form input, .m-post-form textarea { width: 100%; border: 1px solid #ccc; padding: 8px; margin-bottom: 8px; font-size: 13px; }
        .m-hp-field { display: none !important; visibility: hidden; }
        .welcome-box { padding: 20px; line-height: 1.6; }
        .welcome-label { font-weight: bold; color: #0073aa; margin-bottom: 10px; display: block; border-bottom: 2px solid #0073aa; padding-bottom: 3px; font-size: 14px; }
        
        /* フォーラム説明文エリアのズレ修正用CSS */
        .forum-description-content { line-height: 1.8; white-space: pre-wrap; color: #444; font-size: 14px; display: block; margin: 0; padding: 0; }
    </style>

    <div class="m-forum-wrapper">
        <div class="m-forum-sidebar">
            <h3 style="font-size:10px; color:#999; margin: 8px;">会議室一覧</h3>
            <a href="<?php echo esc_url(remove_query_arg('fid')); ?>" class="forum-link <?php echo ($current_fid == 0) ? 'active' : ''; ?>">HOME</a>
            <?php if($forums): foreach($forums as $f): ?>
                <a href="<?php echo esc_url(add_query_arg('fid', $f->id)); ?>" class="forum-link <?php echo ($current_fid == $f->id) ? 'active' : ''; ?>"># <?php echo esc_html($f->name); ?></a>
            <?php endforeach; endif; ?>
        </div>

        <div class="m-forum-content">
            <?php if ($current_fid > 0): ?>
                <div class="m-post-list">
                    <a href="javascript:void(0)" onclick="openForm(0, '')" class="new-post-btn">＋ 新規スレッド作成</a>
                    <?php
                    $raw_posts = $wpdb->get_results($wpdb->prepare("SELECT * FROM {$wpdb->prefix}m_kaigishitsu_posts WHERE forum_id = %d ORDER BY created_at ASC", $current_fid));
                    if($raw_posts) {
                        $tree = array_reverse(m_kaigishitsu_build_tree_data($raw_posts));
                        m_kaigishitsu_render_tree_html($tree);
                    }
                    ?>
                </div>
                <div class="m-post-detail">
                    <div id="post-content-area">
                        <!-- 位置ズレ対策：ラベルを独立させ、本文に余計な空白を入れないように配置 -->
                        <span class="welcome-label"># <?php echo esc_html($current_forum->name); ?> について</span>
                        <div class="forum-description-content"><?php echo $current_forum->description ? wp_kses_post(trim($current_forum->description)) : 'この会議室にはまだ説明がありません。'; ?></div>
                        <p style="text-align:center; color:#999; margin-top:40px; border-top:1px dashed #eee; padding-top:20px;">↑ 上の一覧からタイトルをクリックすると内容が表示されます</p>
                    </div>

                    <div id="post-form-area" class="m-post-form">
                        <form method="post">
                            <div class="m-hp-field"><input type="text" name="m_kaigishitsu_hp" tabindex="-1"></div>
                            <input type="text" name="author" id="form-author" placeholder="お名前" required>
                            <input type="text" name="title" id="form-title" placeholder="タイトル" required>
                            <textarea name="body" id="form-body" rows="6" placeholder="本文..."></textarea>
                            <input type="password" name="password" id="form-pass" placeholder="パスワード" required>
                            <input type="hidden" name="forum_id" value="<?php echo $current_fid; ?>">
                            <input type="hidden" name="parent_id" id="form-parent-id" value="0">
                            <input type="hidden" name="edit_post_id" id="form-edit-id" value="0">
                            <button type="submit" name="m_kaigishitsu_submit" class="btn" style="background:#0073aa; color:#fff; border:none; padding:8px 20px;">送信する</button>
                            <button type="button" onclick="closeForm()" class="btn">中止</button>
                        </form>
                    </div>
                    <div id="delete-form-area" class="m-post-form">
                        <form method="post">
                            <?php if(!$is_admin): ?><input type="password" name="del_password" placeholder="パスワードを入力" required><?php endif; ?>
                            <input type="hidden" name="delete_post_id" id="delete-post-id" value="0">
                            <button type="submit" name="m_kaigishitsu_delete" class="btn" style="background:#d63638; color:#fff; border:none;">削除実行</button>
                            <button type="button" onclick="closeForm()" class="btn">中止</button>
                        </form>
                    </div>
                </div>
            <?php else: ?>
                <div class="m-post-list welcome-box">
                    <span class="welcome-label"><?php echo esc_html(get_option('m_kaigishitsu_label_top', 'お知らせ')); ?></span>
                    <div class="forum-description-content"><?php echo wpautop(get_option('m_kaigishitsu_msg_top', '会議室を選択してください。')); ?></div>
                </div>
                <div class="m-post-detail welcome-box" style="background:#fcfcfc;">
                    <span class="welcome-label"><?php echo esc_html(get_option('m_kaigishitsu_label_bottom', '会議室のご案内')); ?></span>
                    <div class="forum-description-content"><?php echo wpautop(get_option('m_kaigishitsu_msg_bottom', '管理者からの案内が表示されます。')); ?></div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
    function showPost(id, title, author, date, body) {
        closeForm(); const view = document.getElementById('post-content-area');
        view.innerHTML = `
            <div style="border-bottom:1px solid #eee; padding-bottom:8px; margin-bottom:12px;">
                <div style="font-size:1.3rem; font-weight:bold; color:#222;">${title}</div>
                <div style="font-size:11px; color:#888;">投稿者: <strong>${author}</strong> | ${date}</div>
                <div style="display:flex; gap:6px; margin-top:8px;">
                    <button onclick="openReplyForm(${id}, 'Re: ${title}')" class="btn" style="background:#0073aa; color:#fff; border:none;">返信</button>
                    <button onclick="openEditForm(${id}, '${title}', '${author}', '${body}')" class="btn">編集</button>
                    <button onclick="openDeleteForm(${id})" class="btn" style="color:#d63638;">削除</button>
                </div>
            </div>
            <div style="line-height:1.7; white-space:pre-wrap; font-size:14px; color:#333;">${body}</div>
        `;
    }
    function openReplyForm(pid, title) { openForm(pid, title); }
    function openEditForm(id, title, author, body) { openForm(0, title); document.getElementById('form-edit-id').value = id; document.getElementById('form-author').value = author; document.getElementById('form-body').value = body; }
    function openForm(parentId, title='') { 
        document.getElementById('post-content-area').innerHTML = ''; 
        document.getElementById('post-form-area').style.display = 'block'; 
        document.getElementById('delete-form-area').style.display = 'none'; 
        document.getElementById('form-parent-id').value = parentId; 
        document.getElementById('form-edit-id').value = 0; 
        document.getElementById('form-title').value = title; 
    }
    function openDeleteForm(id) { 
        document.getElementById('post-content-area').innerHTML = ''; 
        document.getElementById('post-form-area').style.display = 'none'; 
        document.getElementById('delete-form-area').style.display = 'block'; 
        document.getElementById('delete-post-id').value = id; 
    }
    function closeForm() { 
        if(document.getElementById('post-form-area')) document.getElementById('post-form-area').style.display = 'none'; 
        if(document.getElementById('delete-form-area')) document.getElementById('delete-form-area').style.display = 'none'; 
    }
    </script>
    <?php return ob_get_clean();
}
add_shortcode('modern_kaigishitsu', 'm_kaigishitsu_shortcode');
